/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.maps;

import org.openstreetmap.atlas.utilities.arrays.Arrays;
import org.openstreetmap.atlas.utilities.arrays.IntegerArrayOfArrays;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.LongArray;
import org.openstreetmap.atlas.utilities.maps.LargeMap;

public class LongToIntegerMultiMap
extends LargeMap<Long, int[]> {
    private static final long serialVersionUID = 6741833447370296269L;

    public LongToIntegerMultiMap(long maximumSize) {
        super(maximumSize);
    }

    public LongToIntegerMultiMap(long maximumSize, int hashSize) {
        super(maximumSize, hashSize);
    }

    public LongToIntegerMultiMap(String name, long maximumSize, int hashSize, int keyMemoryBlockSize, int keySubArraySize, int valueMemoryBlockSize, int valueSubArraySize) {
        super(name, maximumSize, hashSize, keyMemoryBlockSize, keySubArraySize, valueMemoryBlockSize, valueSubArraySize);
    }

    public void add(Long key, int value) {
        int[] result = this.containsKey(key) ? Arrays.addNewItem((int[])this.get(key), value) : new int[]{value};
        this.put(key, result);
    }

    @Override
    protected LargeArray<Long> createKeys(int memoryBlockSize, int subArraySize) {
        LongArray result = memoryBlockSize > 0 && subArraySize > 0 ? new LongArray(this.getMaximumSize(), memoryBlockSize, subArraySize) : new LongArray(this.getMaximumSize());
        result.withName(this.getName() + " - Keys");
        return result;
    }

    @Override
    protected LargeArray<int[]> createValues(int memoryBlockSize, int subArraySize) {
        IntegerArrayOfArrays result = memoryBlockSize > 0 && subArraySize > 0 ? new IntegerArrayOfArrays(this.getMaximumSize(), memoryBlockSize, subArraySize) : new IntegerArrayOfArrays(this.getMaximumSize());
        result.withName(this.getName() + " - Values");
        return result;
    }
}

