/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.maps;

import org.openstreetmap.atlas.utilities.arrays.BooleanArray;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.LongArray;
import org.openstreetmap.atlas.utilities.maps.LargeMap;

public class LongToBooleanMap
extends LargeMap<Long, Boolean> {
    private static final long serialVersionUID = 346161750484489066L;

    public LongToBooleanMap(long maximumSize) {
        super(maximumSize);
    }

    public LongToBooleanMap(long maximumSize, int hashSize) {
        super(maximumSize, hashSize);
    }

    public LongToBooleanMap(String name, long maximumSize, int hashSize, int keyMemoryBlockSize, int keySubArraySize, int valueMemoryBlockSize, int valueSubArraySize) {
        super(name, maximumSize, hashSize, keyMemoryBlockSize, keySubArraySize, valueMemoryBlockSize, valueSubArraySize);
    }

    @Override
    protected LargeArray<Long> createKeys(int memoryBlockSize, int subArraySize) {
        LongArray result = memoryBlockSize > 0 && subArraySize > 0 ? new LongArray(this.getMaximumSize(), memoryBlockSize, subArraySize) : new LongArray(this.getMaximumSize());
        result.withName(this.getName() + " - Keys");
        return result;
    }

    @Override
    protected LargeArray<Boolean> createValues(int memoryBlockSize, int subArraySize) {
        BooleanArray result = memoryBlockSize > 0 && subArraySize > 0 ? new BooleanArray(this.getMaximumSize(), memoryBlockSize, subArraySize) : new BooleanArray(this.getMaximumSize());
        result.withName(this.getName() + " - Values");
        return result;
    }
}

