/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.maps;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.arrays.Arrays;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.LongArrayOfArrays;
import org.openstreetmap.atlas.utilities.scalars.Ratio;

public abstract class LargeMap<K, V>
implements Iterable<K>,
Serializable {
    private static final long serialVersionUID = -6051549542042379037L;
    protected static final int DEFAULT_HASH_MODULO_RATIO = 10;
    private final LargeArray<V> values;
    private final LargeArray<K> keys;
    private final int hashSize;
    private final long maximumSize;
    private final String name;
    private final LongArrayOfArrays hashes;

    protected LargeMap() {
        this.values = null;
        this.keys = null;
        this.hashSize = 0;
        this.maximumSize = 0L;
        this.name = null;
        this.hashes = null;
    }

    protected LargeMap(long maximumSize) {
        this("LargeMap", maximumSize);
    }

    protected LargeMap(long maximumSize, int hashSize) {
        this("LargeMap", maximumSize, hashSize);
    }

    protected LargeMap(String name, long maximumSize) {
        this(name, maximumSize, (int)Math.min(maximumSize / 10L, Integer.MAX_VALUE));
    }

    protected LargeMap(String name, long maximumSize, int hashSize) {
        this(name, maximumSize, hashSize, -1, -1, -1, -1);
    }

    protected LargeMap(String name, long maximumSize, int hashSize, int keyMemoryBlockSize, int keySubArraySize, int valueMemoryBlockSize, int valueSubArraySize) {
        if (maximumSize < 0L || hashSize <= 0) {
            throw new CoreException("maximumSize(" + maximumSize + ") has to be >=0 and hashSize(" + hashSize + ") has to be > 0");
        }
        this.name = name;
        this.hashes = new LongArrayOfArrays(hashSize, hashSize, hashSize);
        for (int i = 0; i < hashSize; ++i) {
            this.hashes.add(new long[0]);
        }
        this.hashSize = hashSize;
        this.maximumSize = maximumSize;
        this.keys = this.createKeys(keyMemoryBlockSize, keySubArraySize);
        this.values = this.createValues(valueMemoryBlockSize, valueSubArraySize);
    }

    public boolean containsKey(Object key) {
        long[] possibleIndices;
        for (long index : possibleIndices = (long[])this.hashes.get(this.modulo(key.hashCode()))) {
            if (!this.keys.get(index).equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof LargeMap) {
            if (this == other) {
                return true;
            }
            LargeMap that = (LargeMap)other;
            if (!Objects.equals(this.getName(), that.getName())) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            Iterable iterable = () -> this.iterator();
            for (Object key : iterable) {
                V thatValue;
                if (!that.containsKey(key)) {
                    return false;
                }
                V thisValue = this.get(key);
                if (thisValue.equals(thatValue = that.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public V get(Object key) {
        long[] possibleIndices;
        for (long index : possibleIndices = (long[])this.hashes.get(this.modulo(key.hashCode()))) {
            if (!this.keys.get(index).equals(key)) continue;
            return this.values.get(index);
        }
        return null;
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int initialPrime = 31;
        int hashSeed = 37;
        int nameHash = this.getName() == null ? 0 : this.getName().hashCode();
        int hash = 1147 + nameHash;
        hash = 37 * hash + Long.valueOf(this.size()).hashCode();
        Iterable iterable = () -> this.iterator();
        for (Object key : iterable) {
            V value = this.get(key);
            hash = 37 * hash + key.hashCode();
            hash = 37 * hash + value.hashCode();
        }
        return hash;
    }

    public boolean isEmpty() {
        return this.keys.size() <= 0L;
    }

    @Override
    public Iterator<K> iterator() {
        return this.keys.iterator();
    }

    public synchronized void put(K key, V value) {
        long[] possibleIndices;
        long hashIndex = this.modulo(key.hashCode());
        for (long index : possibleIndices = (long[])this.hashes.get(hashIndex)) {
            if (!this.keys.get(index).equals(key)) continue;
            this.values.set(index, value);
            return;
        }
        if (this.size() >= this.maximumSize) {
            throw new CoreException("The map is full.");
        }
        long index = this.keys.size();
        this.keys.add(key);
        this.values.add(value);
        possibleIndices = Arrays.addNewItem(possibleIndices, index);
        this.hashes.set(hashIndex, possibleIndices);
    }

    public long size() {
        return this.keys.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(" ");
        this.forEach(key -> {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(this.asKeyString(key));
            builder.append(" -> ");
            builder.append(this.asValueString(this.get(key)));
        });
        builder.append("]");
        return builder.toString();
    }

    public void trim() {
        this.keys.trim();
        this.values.trim();
    }

    public void trimIfLessFilledThan(Ratio ratio) {
        this.keys.trimIfLessFilledThan(ratio);
        this.values.trimIfLessFilledThan(ratio);
    }

    protected String asKeyString(K key) {
        return key.toString();
    }

    protected String asValueString(V value) {
        return value.toString();
    }

    protected abstract LargeArray<K> createKeys(int var1, int var2);

    protected abstract LargeArray<V> createValues(int var1, int var2);

    private int modulo(int hashValue) {
        boolean negative = hashValue < 0;
        long value = hashValue;
        if (negative) {
            value = -value;
        }
        return (int)(value % (long)this.hashSize);
    }
}

