/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.jsoncompare;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openstreetmap.atlas.utilities.jsoncompare.RegularExpressionJSONCompareResult;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.comparator.JSONComparator;
import org.skyscreamer.jsonassert.comparator.JSONCompareUtil;

public class RegularExpressionJSONComparator
implements JSONComparator {
    private final List<Pattern> searchPatterns = new ArrayList<Pattern>();
    private final JSONCompareMode mode;

    public RegularExpressionJSONComparator(JSONCompareMode mode) {
        this.mode = mode;
    }

    @Override
    public final JSONCompareResult compareJSON(JSONArray expected, JSONArray actual) throws JSONException {
        JSONCompareResult result = this.createResult();
        this.compareJSONArray("", expected, actual, result);
        return result;
    }

    @Override
    public final JSONCompareResult compareJSON(JSONObject expected, JSONObject actual) throws JSONException {
        JSONCompareResult result = this.createResult();
        this.compareJSON("", expected, actual, result);
        return result;
    }

    @Override
    public void compareJSON(String prefix, JSONObject expected, JSONObject actual, JSONCompareResult result) throws JSONException {
        this.checkJsonObjectKeysExpectedInActual(prefix, expected, actual, result);
        if (!this.mode.isExtensible()) {
            this.checkJsonObjectKeysActualInExpected(prefix, expected, actual, result);
        }
    }

    @Override
    public void compareJSONArray(String prefix, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
        if (expected.length() > actual.length()) {
            int end = Math.max(expected.length(), actual.length());
            for (int loop = Math.min(expected.length(), actual.length()); loop < end; ++loop) {
                result.missing(String.format("%s[%d]", prefix, loop), expected.get(loop));
            }
            return;
        }
        if (expected.length() < actual.length()) {
            int end = Math.max(expected.length(), actual.length());
            for (int loop = Math.min(expected.length(), actual.length()); loop < end; ++loop) {
                result.unexpected(String.format("%s[%d]", prefix, loop), actual.get(loop));
            }
            return;
        }
        if (expected.length() == 0) {
            return;
        }
        if (this.mode.hasStrictOrder()) {
            this.compareJSONArrayWithStrictOrder(prefix, expected, actual, result);
        } else if (JSONCompareUtil.allSimpleValues(expected)) {
            this.compareJSONArrayOfSimpleValues(prefix, expected, actual, result);
        } else if (JSONCompareUtil.allJSONObjects(expected)) {
            this.compareJSONArrayOfJsonObjects(prefix, expected, actual, result);
        } else {
            this.recursivelyCompareJSONArray(prefix, expected, actual, result);
        }
    }

    @Override
    public void compareValues(String prefix, Object expectedValue, Object actualValue, JSONCompareResult result) throws JSONException {
        if (expectedValue instanceof Number && actualValue instanceof Number) {
            if (((Number)expectedValue).doubleValue() != ((Number)actualValue).doubleValue()) {
                result.fail(prefix, expectedValue, actualValue);
            }
        } else if (expectedValue.getClass().isAssignableFrom(actualValue.getClass())) {
            if (expectedValue instanceof JSONArray) {
                this.compareJSONArray(prefix, (JSONArray)expectedValue, (JSONArray)actualValue, result);
            } else if (expectedValue instanceof JSONObject) {
                this.compareJSON(prefix, (JSONObject)expectedValue, (JSONObject)actualValue, result);
            } else if (!expectedValue.equals(actualValue)) {
                result.fail(prefix, expectedValue, actualValue);
            }
        } else {
            result.fail(prefix, expectedValue, actualValue);
        }
    }

    public RegularExpressionJSONComparator endsWith(String ... regexes) {
        return this.exact(Stream.of(regexes).map(regex -> String.format("(\\W)*(\\S)*%s$", regex)).collect(Collectors.toList()).toArray(new String[0]));
    }

    public RegularExpressionJSONComparator exact(String ... regexes) {
        Stream.of(regexes).map(Pattern::compile).forEach(this.searchPatterns::add);
        return this;
    }

    public RegularExpressionJSONComparator startsWith(String ... regexes) {
        return this.exact(Stream.of(regexes).map(regex -> String.format("^%s(\\W)*(\\S)*", regex)).collect(Collectors.toList()).toArray(new String[0]));
    }

    protected void checkJsonObjectKeysActualInExpected(String prefix, JSONObject expected, JSONObject actual, JSONCompareResult result) {
        JSONCompareUtil.getKeys(actual).stream().filter(key -> !expected.has((String)key)).forEach(key -> result.unexpected(prefix, key));
    }

    protected void checkJsonObjectKeysExpectedInActual(String prefix, JSONObject expected, JSONObject actual, JSONCompareResult result) throws JSONException {
        for (String key : JSONCompareUtil.getKeys(expected)) {
            if (actual.has(key)) {
                this.compareValues(JSONCompareUtil.qualify(prefix, key), expected.get(key), actual.get(key), result);
                continue;
            }
            result.missing(prefix, key);
        }
    }

    protected void compareJSONArrayOfJsonObjects(String key, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
        String uniqueKey = JSONCompareUtil.findUniqueKey(expected);
        if (uniqueKey == null || !JSONCompareUtil.isUsableAsUniqueKey(uniqueKey, actual)) {
            this.recursivelyCompareJSONArray(key, expected, actual, result);
            return;
        }
        Map<Object, JSONObject> expectedValueMap = JSONCompareUtil.arrayOfJsonObjectToMap(expected, uniqueKey);
        Map<Object, JSONObject> actualValueMap = JSONCompareUtil.arrayOfJsonObjectToMap(actual, uniqueKey);
        for (Object identifier : expectedValueMap.keySet()) {
            if (!actualValueMap.containsKey(identifier)) {
                result.missing(JSONCompareUtil.formatUniqueKey(key, uniqueKey, identifier), expectedValueMap.get(identifier));
                continue;
            }
            JSONObject expectedValue = expectedValueMap.get(identifier);
            JSONObject actualValue = actualValueMap.get(identifier);
            this.compareValues(JSONCompareUtil.formatUniqueKey(key, uniqueKey, identifier), expectedValue, actualValue, result);
        }
        for (Object identifier : actualValueMap.keySet()) {
            if (expectedValueMap.containsKey(identifier)) continue;
            result.unexpected(JSONCompareUtil.formatUniqueKey(key, uniqueKey, identifier), actualValueMap.get(identifier));
        }
    }

    protected void compareJSONArrayOfSimpleValues(String key, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
        Map<Object, Integer> expectedCount = JSONCompareUtil.getCardinalityMap(JSONCompareUtil.jsonArrayToList(expected));
        Map<Object, Integer> actualCount = JSONCompareUtil.getCardinalityMap(JSONCompareUtil.jsonArrayToList(actual));
        for (Object foundKey : expectedCount.keySet()) {
            if (!actualCount.containsKey(foundKey)) {
                result.missing(key + "[]", foundKey);
                continue;
            }
            if (actualCount.get(foundKey).equals(expectedCount.get(foundKey))) continue;
            result.fail(key + "[]: Expected " + expectedCount.get(foundKey) + " occurrence(s) of " + foundKey + " but got " + actualCount.get(foundKey) + " occurrence(s)");
        }
        for (Object foundKey : actualCount.keySet()) {
            if (expectedCount.containsKey(foundKey)) continue;
            result.unexpected(key + "[]", foundKey);
        }
    }

    protected void compareJSONArrayWithStrictOrder(String key, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
        for (int i = 0; i < expected.length(); ++i) {
            Object expectedValue = expected.get(i);
            Object actualValue = actual.get(i);
            this.compareValues(key + "[" + i + "]", expectedValue, actualValue, result);
        }
    }

    protected JSONCompareResult createResult() {
        return new RegularExpressionJSONCompareResult(this.searchPatterns);
    }

    protected void recursivelyCompareJSONArray(String key, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
        HashSet<Integer> matched = new HashSet<Integer>();
        for (int i = 0; i < expected.length(); ++i) {
            Object expectedElement = expected.get(i);
            boolean matchFound = false;
            for (int j = 0; j < actual.length(); ++j) {
                Object actualElement = actual.get(j);
                if (matched.contains(j) || !actualElement.getClass().equals(expectedElement.getClass())) continue;
                if (expectedElement instanceof JSONObject) {
                    if (!this.compareJSON((JSONObject)expectedElement, (JSONObject)actualElement).passed()) continue;
                    matched.add(j);
                    matchFound = true;
                    break;
                }
                if (expectedElement instanceof JSONArray) {
                    if (!this.compareJSON((JSONArray)expectedElement, (JSONArray)actualElement).passed()) continue;
                    matched.add(j);
                    matchFound = true;
                    break;
                }
                if (!expectedElement.equals(actualElement)) continue;
                matched.add(j);
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            result.fail(key + "[" + i + "] Could not find match for element " + expectedElement);
            return;
        }
    }
}

