/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.configuration;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.configuration.Configurable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationDeserializer;
import org.openstreetmap.atlas.utilities.configuration.MergedConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardConfiguration
implements Configuration {
    private static final String OVERRIDE_STRING = "override";
    private static final String DOT = ".";
    private static final Logger logger = LoggerFactory.getLogger(StandardConfiguration.class);
    private Map<String, Object> configurationData;
    private final String name;

    public StandardConfiguration(Resource resource) {
        this(resource, ConfigurationFormat.UNKNOWN);
    }

    public StandardConfiguration(Resource resource, ConfigurationFormat configFormat) {
        this.name = resource.getName();
        byte[] configBytes = resource.readBytesAndClose();
        switch (configFormat) {
            case JSON: {
                this.configurationData = this.readConfigurationMapFromJSON(configBytes).orElseThrow(() -> new CoreException("Unable to load JSON configuration."));
                return;
            }
            case YAML: {
                this.configurationData = this.readConfigurationMapFromYAML(configBytes).orElseThrow(() -> new CoreException("Unable to load YAML configuration."));
                return;
            }
        }
        Optional<Map> loadedConfigMap = Stream.of(() -> this.readConfigurationMapFromJSON(configBytes), () -> this.readConfigurationMapFromYAML(configBytes)).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
        this.configurationData = loadedConfigMap.orElseThrow(() -> new CoreException("Unable to load UNKNOWN configuration."));
    }

    public StandardConfiguration(String name, Map<String, Object> configurationData) {
        this.name = name;
        this.configurationData = configurationData;
    }

    @Override
    public Set<String> configurationDataKeySet() {
        return new HashSet<String>(this.configurationData.keySet());
    }

    @Override
    public Configuration configurationForKeyword(String keyword) {
        Optional<Map<String, Object>> overrideDataForKeyword = this.getOverrideDataForKeyword(keyword, this.configurationData);
        if (overrideDataForKeyword.isPresent()) {
            return new MergedConfiguration(new StandardConfiguration(this.name, overrideDataForKeyword.get()), this);
        }
        return this;
    }

    @Override
    public Configurable get(String key) {
        return new StandardConfigurable(key, null, Function.identity());
    }

    @Override
    public <R, T> Configurable get(String key, Function<R, T> transform) {
        return new StandardConfigurable<Object, T>(key, null, transform);
    }

    public Configurable get(String key, Object defaultValue) {
        return new StandardConfigurable(key, defaultValue, Function.identity());
    }

    @Override
    public <R, T> Configurable get(String key, R defaultValue, Function<R, T> transform) {
        return new StandardConfigurable<R, T>(key, defaultValue, transform);
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }

    private Optional<Map<String, Object>> getOverrideDataForKeyword(String keyword, Map<String, Object> currentContext) {
        List<String> overrideKeyPrefixList = Arrays.asList(OVERRIDE_STRING, keyword);
        String overrideKeyPrefixString = String.join((CharSequence)DOT, overrideKeyPrefixList);
        HashMap<String, Object> overrideData = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : currentContext.entrySet()) {
            String key = entry.getKey();
            if (key.equals(OVERRIDE_STRING)) continue;
            String overrideKey = String.join((CharSequence)DOT, overrideKeyPrefixString, key);
            Optional<Object> specificOverrideData = Optional.ofNullable(this.resolve(overrideKey, currentContext));
            if (specificOverrideData.isPresent()) {
                overrideData.put(key, specificOverrideData.get());
                continue;
            }
            Object nextContext = entry.getValue();
            if (!(nextContext instanceof Map)) continue;
            this.getOverrideDataForKeyword(keyword, (Map)nextContext).ifPresent(moreOverrideData -> overrideData.put(key, moreOverrideData));
        }
        return Optional.of(overrideData).filter(data -> !data.isEmpty());
    }

    private Optional<Map<String, Object>> readConfigurationMapFromJSON(byte[] readBytes) {
        Optional<Map<String, Object>> optional;
        logger.info("Attempting to load configuration as JSON");
        ByteArrayInputStream read = new ByteArrayInputStream(readBytes);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addDeserializer(Map.class, new ConfigurationDeserializer());
            objectMapper.registerModule(simpleModule);
            JsonParser parser = new JsonFactory().createParser(read);
            Map readConfig = objectMapper.readValue(parser, Map.class);
            logger.info("Success! Loaded JSON configuration");
            optional = Optional.of(readConfig);
        }
        catch (Throwable throwable) {
            try {
                try {
                    read.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception jsonReadException) {
                logger.warn("Unable to parse config file as JSON");
                return Optional.empty();
            }
        }
        read.close();
        return optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Map<String, Object>> readConfigurationMapFromYAML(byte[] readBytes) {
        ByteArrayInputStream read = new ByteArrayInputStream(readBytes);
        logger.info("Attempting to load configuration as YAML.");
        try {
            ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addDeserializer(Map.class, new ConfigurationDeserializer());
            objectMapper.registerModule(simpleModule);
            YAMLParser parser = new YAMLFactory().createParser(read);
            Map readConfig = objectMapper.readValue((JsonParser)parser, Map.class);
            logger.info("Success! Loaded YAML configuration.");
            Optional<Map<String, Object>> optional = Optional.of(readConfig);
            return optional;
        }
        catch (Exception yamlReadException) {
            logger.warn("Unable to parse config file as YAML");
            Optional<Map<String, Object>> optional = Optional.empty();
            return optional;
        }
        finally {
            IOUtils.closeQuietly(read);
        }
    }

    private Object resolve(String key, Map<String, Object> currentContext) {
        if (StringUtils.isEmpty(key)) {
            return currentContext;
        }
        LinkedList<String> rootParts = new LinkedList<String>(Arrays.asList(key.split("\\.")));
        LinkedList<String> childParts = new LinkedList<String>();
        while (!rootParts.isEmpty()) {
            String currentKey = String.join((CharSequence)DOT, rootParts);
            Object nextItem = currentContext.get(currentKey);
            if (nextItem instanceof Map) {
                String nextKey = String.join((CharSequence)DOT, childParts);
                return this.resolve(nextKey, (Map)nextItem);
            }
            if (nextItem != null) {
                return nextItem;
            }
            childParts.addFirst(rootParts.removeLast());
        }
        return null;
    }

    private final class StandardConfigurable<R, T>
    implements Configurable {
        private final T defaultValue;
        private final String key;
        private final Function<R, T> transform;

        private StandardConfigurable(String key, R defaultValue, Function<R, T> transform) {
            this.key = key;
            this.transform = transform;
            this.defaultValue = Optional.ofNullable(defaultValue).map(transform).orElse(null);
        }

        @Override
        public <V> V value() {
            try {
                Object found = StandardConfiguration.this.resolve(this.key, StandardConfiguration.this.configurationData);
                return (V)Optional.ofNullable(found).map(this.transform).orElse(this.defaultValue);
            }
            catch (ClassCastException e) {
                logger.error(String.format("Invalid configuration type for %s", this.key), (Throwable)e);
                return null;
            }
        }

        @Override
        public <V> Optional<V> valueOption() {
            return Optional.ofNullable(this.value());
        }
    }

    public static enum ConfigurationFormat {
        JSON,
        YAML,
        UNKNOWN;

    }
}

