/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.configuration;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.conversion.StringToPredicateConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfiguredFilter
implements Predicate<AtlasEntity>,
Serializable {
    private static final long serialVersionUID = 7503301238426719144L;
    private static final Logger logger = LoggerFactory.getLogger(ConfiguredFilter.class);
    public static final String DEFAULT = "default";
    private static final String CONFIGURATION_GLOBAL = "global";
    public static final String CONFIGURATION_ROOT = "global.filters";
    private static final String CONFIGURATION_PREDICATE_COMMAND = "predicate.command";
    private static final String CONFIGURATION_PREDICATE_IMPORTS = "predicate.imports";
    private static final String CONFIGURATION_TAGGABLE_FILTER = "taggableFilter";
    public static final ConfiguredFilter NO_FILTER = new ConfiguredFilter();
    private final String name;
    private final String predicate;
    private final List<String> imports;
    private final String taggableFilter;
    private transient Predicate<AtlasEntity> filter;

    public static ConfiguredFilter from(String name, Configuration configuration) {
        if (DEFAULT.equals(name)) {
            return ConfiguredFilter.getDefaultFilter(configuration);
        }
        if (!ConfiguredFilter.isPresent(name, configuration)) {
            logger.warn("Attempted to create ConfiguredFilter called \"{}\" but it was not found. It will be swapped with default passthrough filter.", (Object)name);
            return ConfiguredFilter.getDefaultFilter(configuration);
        }
        return new ConfiguredFilter(name, configuration);
    }

    public static ConfiguredFilter getDefaultFilter(Configuration configuration) {
        if (ConfiguredFilter.isPresent(DEFAULT, configuration)) {
            return new ConfiguredFilter(DEFAULT, configuration);
        }
        return NO_FILTER;
    }

    public static boolean isPresent(String name, Configuration configuration) {
        return new ConfigurationReader(CONFIGURATION_ROOT).isPresent(configuration, name);
    }

    private ConfiguredFilter() {
        this("NO_FILTER", new StandardConfiguration(new StringResource("{}")));
    }

    private ConfiguredFilter(String name, Configuration configuration) {
        this.name = name;
        ConfigurationReader reader = new ConfigurationReader("global.filters." + name);
        this.predicate = reader.configurationValue(configuration, CONFIGURATION_PREDICATE_COMMAND, "");
        this.imports = reader.configurationValue(configuration, CONFIGURATION_PREDICATE_IMPORTS, Lists.newArrayList());
        this.taggableFilter = reader.configurationValue(configuration, CONFIGURATION_TAGGABLE_FILTER, "");
    }

    @Override
    public boolean test(AtlasEntity atlasEntity) {
        return this.getFilter().test(atlasEntity);
    }

    public String toString() {
        return this.name;
    }

    private Predicate<AtlasEntity> getFilter() {
        if (this.filter == null) {
            Predicate<AtlasEntity> localTemporaryPredicate = atlasEntity -> true;
            if (!this.predicate.isEmpty()) {
                StringToPredicateConverter predicateReader = new StringToPredicateConverter();
                predicateReader.withAddedStarImportPackages(this.imports);
                localTemporaryPredicate = predicateReader.convert(this.predicate);
            }
            Predicate<AtlasEntity> localPredicate = localTemporaryPredicate;
            TaggableFilter localTaggablefilter = TaggableFilter.forDefinition(this.taggableFilter);
            this.filter = atlasEntity -> localPredicate.test((AtlasEntity)atlasEntity) && localTaggablefilter.test((Taggable)atlasEntity);
        }
        return this.filter;
    }
}

