/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.configuration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class ConfigurationReader {
    private static final String CONFIGURATION_PATH_NAME_DEFAULT = "N/A";
    private final String root;

    public ConfigurationReader(String root) {
        this.root = root;
    }

    public final String configurationKey(String key) {
        return this.root.isEmpty() ? key : this.root + "." + key;
    }

    public String configurationValue(Configuration configuration, String key) {
        String result = (String)configuration.get(this.configurationKey(key), CONFIGURATION_PATH_NAME_DEFAULT).value();
        if (CONFIGURATION_PATH_NAME_DEFAULT.equals(result)) {
            throw new CoreException("Malformed configuration for {}", this.configurationKey(key));
        }
        return result;
    }

    public <U> U configurationValue(Configuration configuration, String key, U defaultValue) {
        return (U)configuration.get(this.configurationKey(key), defaultValue).value();
    }

    public <R, T> T configurationValue(Configuration configuration, Function<R, T> defaultValue) {
        return (T)configuration.get(this.root, defaultValue).value();
    }

    public List<String> configurationValues(Configuration configuration, String key) {
        List result;
        ArrayList<String> defaults = Lists.newArrayList(CONFIGURATION_PATH_NAME_DEFAULT);
        if (defaults.equals(result = (List)configuration.get(this.configurationKey(key), defaults).value())) {
            throw new CoreException("Malformed configuration for {}", this.configurationKey(key));
        }
        return result;
    }

    public boolean isPresent(Configuration configuration, String key) {
        Object result = configuration.get(this.configurationKey(key), CONFIGURATION_PATH_NAME_DEFAULT).value();
        return !CONFIGURATION_PATH_NAME_DEFAULT.equals(result);
    }
}

