/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.terminal;

import java.util.ArrayDeque;
import java.util.Deque;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;

public class TTYStringBuilder {
    public static final int DEFAULT_LEVEL_WIDTH = 4;
    private final StringBuilder builder = new StringBuilder();
    private final boolean useColors;
    private final Deque<Integer> exactIndentWidthStack;
    private int levelWidth;

    public TTYStringBuilder(boolean useColors) {
        this.useColors = useColors;
        this.exactIndentWidthStack = new ArrayDeque<Integer>();
        this.exactIndentWidthStack.push(0);
        this.levelWidth = 4;
    }

    public TTYStringBuilder append(Object object, TTYAttribute ... attributes) {
        for (int i = 0; i < this.exactIndentWidthStack.peek(); ++i) {
            this.builder.append(" ");
        }
        if (this.useColors) {
            for (TTYAttribute attribute : attributes) {
                this.builder.append(attribute.getANSISequence());
            }
        }
        this.builder.append(String.valueOf(object));
        if (this.useColors && attributes.length > 0) {
            this.builder.append(TTYAttribute.RESET.getANSISequence());
        }
        return this;
    }

    public TTYStringBuilder clearIndentationStack() {
        this.exactIndentWidthStack.clear();
        this.exactIndentWidthStack.push(0);
        return this;
    }

    public TTYStringBuilder newline() {
        this.builder.append(System.getProperty("line.separator"));
        return this;
    }

    public TTYStringBuilder popIndentation() {
        if (this.exactIndentWidthStack.size() == 1) {
            throw new CoreException("Cannot pop default indention off the stack");
        }
        this.exactIndentWidthStack.pop();
        return this;
    }

    public TTYStringBuilder pushExactIndentWidth(int width) {
        if (width < 0) {
            throw new CoreException("Indent width ({}) must be >= 0", width);
        }
        this.exactIndentWidthStack.push(width);
        return this;
    }

    public TTYStringBuilder pushIndentLevel(int level) {
        if (level < 0) {
            throw new CoreException("Indent level ({}) must be >= 0", level);
        }
        this.exactIndentWidthStack.push(level * this.levelWidth);
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    public TTYStringBuilder withLevelWidth(int newLevelWidth) {
        if (newLevelWidth < 0) {
            throw new CoreException("Level width ({}) must be >= 0", newLevelWidth);
        }
        this.levelWidth = newLevelWidth;
        return this;
    }
}

