/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands.templates;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.subcommands.templates.MultipleOutputCommand;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public abstract class AtlasLoaderCommand
extends MultipleOutputCommand {
    private static final String COMBINED_ATLAS_NAME = "combined.atlas";
    private static final String INPUT_HINT = "input-atlases";
    private static final String COMBINE_OPTION_LONG = "combine";
    private static final String COMBINE_OPTION_DESCRIPTION = "Combine all input atlases into a MultiAtlas before processing.";
    private static final String STRICT_OPTION_LONG = "strict";
    private static final String STRICT_OPTION_DESCRIPTION = "Fail fast if any input atlases are missing.";
    private static final String PARALLEL_OPTION_LONG = "parallel";
    private static final Character PARALLEL_OPTION_SHORT = Character.valueOf('p');
    private static final String PARALLEL_OPTION_DESCRIPTION = "Process the atlases in parallel.";
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();
    private List<Tuple<File, Atlas>> atlases = null;

    public static String removeSuffixFromFileName(String fileName) {
        String[] split = fileName.split("\\.");
        return split[0];
    }

    @Override
    public int execute() {
        int code = super.execute();
        if (code != 0) {
            return code;
        }
        code = this.start();
        if (code != 0) {
            return code;
        }
        List<Tuple<File, Atlas>> atlasTuples = this.getInputAtlases();
        if (atlasTuples.isEmpty()) {
            this.outputDelegate.printlnErrorMessage("no atlas files were loaded");
            return 1;
        }
        Stream atlasTupleStream = atlasTuples.stream();
        if (this.optionAndArgumentDelegate.hasOption(PARALLEL_OPTION_LONG)) {
            atlasTupleStream = (Stream)atlasTupleStream.parallel();
        }
        if (this.optionAndArgumentDelegate.hasOption(COMBINE_OPTION_LONG)) {
            this.processAtlas(new MultiAtlas(atlasTupleStream.map(Tuple::getSecond).collect(Collectors.toList())), COMBINED_ATLAS_NAME, new File(COMBINED_ATLAS_NAME));
        } else {
            atlasTupleStream.forEach(atlasTuple -> this.processAtlas((Atlas)atlasTuple.getSecond(), ((File)atlasTuple.getFirst()).getName(), (File)atlasTuple.getFirst()));
        }
        return this.finish();
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("ATLAS LOADER", AtlasLoaderCommand.class.getResourceAsStream("AtlasLoaderCommandSection.txt"));
        super.registerManualPageSections();
    }

    @Override
    public void registerOptionsAndArguments() {
        Integer[] contexts = this.optionAndArgumentDelegate.getFilteredRegisteredContexts().toArray(new Integer[0]);
        this.registerOption(STRICT_OPTION_LONG, STRICT_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, contexts);
        this.registerOption(PARALLEL_OPTION_LONG, PARALLEL_OPTION_SHORT, PARALLEL_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, contexts);
        this.registerOption(COMBINE_OPTION_LONG, COMBINE_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, contexts);
        this.registerArgument(INPUT_HINT, ArgumentArity.VARIADIC, ArgumentOptionality.REQUIRED, contexts);
        super.registerOptionsAndArguments();
    }

    protected int finish() {
        return 0;
    }

    protected abstract void processAtlas(Atlas var1, String var2, File var3);

    protected int start() {
        return 0;
    }

    private List<Tuple<File, Atlas>> getInputAtlases() {
        if (this.atlases != null) {
            return this.atlases;
        }
        this.atlases = new ArrayList<Tuple<File, Atlas>>();
        List<String> inputAtlasPaths = this.optionAndArgumentDelegate.getVariadicArgument(INPUT_HINT);
        AtlasResourceLoader loader = new AtlasResourceLoader();
        inputAtlasPaths.stream().forEach(path -> {
            File file = new File((String)path, false);
            if (!file.exists()) {
                this.outputDelegate.printlnWarnMessage("file not found: " + path);
            } else if (file.isDirectory()) {
                this.outputDelegate.printlnWarnMessage("skipping directory: " + path);
            } else {
                Atlas atlas;
                if (this.optionAndArgumentDelegate.hasVerboseOption()) {
                    this.outputDelegate.printlnCommandMessage("loading " + path);
                }
                if ((atlas = loader.load(file)) != null) {
                    this.atlases.add(new Tuple<File, Atlas>(file, atlas));
                } else {
                    this.outputDelegate.printlnWarnMessage("could not load: " + file);
                }
            }
        });
        if (this.optionAndArgumentDelegate.hasOption(STRICT_OPTION_LONG) && this.atlases.size() != inputAtlasPaths.size()) {
            this.outputDelegate.printlnErrorMessage("strict load is missing some atlas(es)");
            this.atlases = new ArrayList<Tuple<File, Atlas>>();
        }
        return this.atlases;
    }
}

