/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.streaming.compression.Decompressor;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.subcommands.templates.MultipleOutputCommand;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;

public class PbfToAtlasCommand
extends MultipleOutputCommand {
    private static final String PBF_PATH_HINT = "pbf";
    private static final String COUNTRY_NAME = "countryName";
    private static final String BOUNDS = "bounds";
    private static final String RAW = "raw";
    private static final String COUNTRY_NAME_DESCRIPTION = "The country for the shard to build";
    private static final String BOUNDS_DESCRIPTION = "The file containing WKT bounds to restrain the loading.";
    private static final String RAW_DESCRIPTION = "Whether or not to stop at the raw atlas. If this is enabled, way-sectioning will not happen";
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();
    private List<File> pbfs;

    public static void main(String[] args) {
        new PbfToAtlasCommand().runSubcommandAndExit(args);
    }

    @Override
    public int execute() {
        int code = super.execute();
        if (code != 0) {
            return code;
        }
        this.getInputPBFs();
        String countryName = this.optionAndArgumentDelegate.getOptionArgument(COUNTRY_NAME).orElseThrow(AtlasShellToolsException::new);
        this.pbfs.forEach(pbf -> {
            PackedAtlas atlas = (PackedAtlas)new RawAtlasGenerator((Resource)pbf, AtlasLoadingOption.createOptionWithOnlySectioning(), this.getBounds()).build();
            String pbfName = pbf.getName().replace(FileSuffix.PBF.toString(), "");
            String rawAtlasFilename = String.format("%s%s%s%s", new Object[]{countryName, "_", pbfName, FileSuffix.ATLAS});
            if (!this.stopAtRaw()) {
                WaySectionProcessor waySectionProcessor = new WaySectionProcessor(atlas, AtlasLoadingOption.createOptionWithNoSlicing());
                atlas = (PackedAtlas)waySectionProcessor.run();
            }
            atlas.setSaveSerializationFormat(PackedAtlas.AtlasSerializationFormat.PROTOBUF);
            Path concatenatedPath = this.optionAndArgumentDelegate.hasOption("output") ? Paths.get(this.getOutputPath().toAbsolutePath().toString(), rawAtlasFilename) : Paths.get(Paths.get(pbf.getAbsolutePath(), new String[0]).getParent().toAbsolutePath().toString(), rawAtlasFilename);
            this.outputDelegate.printlnStdout(concatenatedPath.toAbsolutePath().toString(), new TTYAttribute[0]);
            File outputFile = new File(concatenatedPath.toAbsolutePath().toString());
            atlas.save(outputFile);
        });
        return 0;
    }

    @Override
    public String getCommandName() {
        return "pbf2atlas";
    }

    @Override
    public String getSimpleDescription() {
        return "Generate way-sectioned Atlas file(s) from the given PBF shard(s)";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", PbfToAtlasCommand.class.getResourceAsStream("PbfToAtlasDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", PbfToAtlasCommand.class.getResourceAsStream("PbfToAtlasCommandExamplesSection.txt"));
    }

    @Override
    public void registerOptionsAndArguments() {
        Integer[] contexts = this.optionAndArgumentDelegate.getFilteredRegisteredContexts().toArray(new Integer[0]);
        this.registerArgument(PBF_PATH_HINT, ArgumentArity.VARIADIC, ArgumentOptionality.REQUIRED, contexts);
        this.registerOptionWithRequiredArgument(COUNTRY_NAME, COUNTRY_NAME_DESCRIPTION, OptionOptionality.REQUIRED, COUNTRY_NAME, new Integer[0]);
        this.registerOptionWithRequiredArgument(BOUNDS, BOUNDS_DESCRIPTION, OptionOptionality.OPTIONAL, BOUNDS, new Integer[0]);
        this.registerOption(RAW, RAW_DESCRIPTION, OptionOptionality.OPTIONAL, new Integer[0]);
        super.registerOptionsAndArguments();
    }

    private MultiPolygon getBounds() {
        Optional<String> boundsFilePathOption = this.optionAndArgumentDelegate.getOptionArgument(BOUNDS);
        if (boundsFilePathOption.isPresent()) {
            String wktFileName = boundsFilePathOption.get();
            File wktFile = new File(wktFileName);
            if (wktFileName.endsWith(FileSuffix.GZIP.toString())) {
                wktFile.setDecompressor(Decompressor.GZIP);
            }
            String wkt = wktFile.firstLine();
            return MultiPolygon.wkt(wkt);
        }
        return MultiPolygon.MAXIMUM;
    }

    private void getInputPBFs() {
        if (this.pbfs != null) {
            return;
        }
        this.pbfs = new ArrayList<File>();
        List<String> inputPbfPaths = this.optionAndArgumentDelegate.getVariadicArgument(PBF_PATH_HINT);
        inputPbfPaths.forEach(path -> {
            File file = new File((String)path, false);
            if (!file.exists()) {
                this.outputDelegate.printlnWarnMessage("file not found: " + path);
            } else if (file.isDirectory()) {
                this.outputDelegate.printlnWarnMessage("skipping directory: " + path);
            } else {
                if (this.optionAndArgumentDelegate.hasVerboseOption()) {
                    this.outputDelegate.printlnCommandMessage("loading " + path);
                }
                this.pbfs.add(file);
            }
        });
    }

    private boolean stopAtRaw() {
        return this.optionAndArgumentDelegate.hasOption(RAW);
    }
}

