/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.testing.OsmFileParser;

public class OsmFileParserCommand
extends AbstractAtlasShellToolsCommand {
    private static final String JOSM_OSM_FILE = "josm";
    private static final String OSM_FILE = "osm";
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();

    public static void main(String[] args) {
        new OsmFileParserCommand().runSubcommandAndExit(args);
    }

    @Override
    public int execute() {
        String josmOsmFile = this.optionAndArgumentDelegate.getUnaryArgument(JOSM_OSM_FILE).orElseThrow(AtlasShellToolsException::new);
        String osmFile = this.optionAndArgumentDelegate.getUnaryArgument(JOSM_OSM_FILE).orElseThrow(AtlasShellToolsException::new);
        new OsmFileParser().update(new File(josmOsmFile), new File(osmFile));
        return 0;
    }

    @Override
    public String getCommandName() {
        return "josm2osm";
    }

    @Override
    public String getSimpleDescription() {
        return "Transform a JOSM OSM file into a real OSM file.";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", OsmFileParserCommand.class.getResourceAsStream("OsmFileParserCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", OsmFileParserCommand.class.getResourceAsStream("OsmFileParserCommandExamplesSection.txt"));
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerArgument(JOSM_OSM_FILE, ArgumentArity.UNARY, ArgumentOptionality.REQUIRED, new Integer[0]);
        this.registerArgument(OSM_FILE, ArgumentArity.UNARY, ArgumentOptionality.REQUIRED, new Integer[0]);
        super.registerOptionsAndArguments();
    }
}

