/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.subcommands.templates.AtlasLoaderCommand;

public class ConcatenateAtlasCommand
extends AtlasLoaderCommand {
    private static final String OUTPUT_ATLAS = "output.atlas";
    private final OptionAndArgumentDelegate optionAndArgumentDelegate;
    private final CommandOutputDelegate outputDelegate;
    private final List<Atlas> atlases = new ArrayList<Atlas>();

    public static void main(String[] args) {
        new ConcatenateAtlasCommand().runSubcommandAndExit(args);
    }

    public ConcatenateAtlasCommand() {
        this.optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
        this.outputDelegate = this.getCommandOutputDelegate();
    }

    @Override
    public String getCommandName() {
        return "fatlas";
    }

    @Override
    public String getSimpleDescription() {
        return "create and save a fatlas using the MultiAtlas";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", ConcatenateAtlasCommand.class.getResourceAsStream("ConcatenateAtlasCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", ConcatenateAtlasCommand.class.getResourceAsStream("ConcatenateAtlasCommandExamplesSection.txt"));
        super.registerManualPageSections();
    }

    @Override
    protected int finish() {
        if (this.atlases.isEmpty()) {
            this.outputDelegate.printlnErrorMessage("could not load atlas(es)");
            return 1;
        }
        MultiAtlas atlas = new MultiAtlas(this.atlases);
        if (this.optionAndArgumentDelegate.hasVerboseOption()) {
            this.outputDelegate.printlnCommandMessage("cloning...");
        }
        PackedAtlas outputAtlas = new PackedAtlasCloner().cloneFrom(atlas);
        Path concatenatedPath = Paths.get(this.getOutputPath().toAbsolutePath().toString(), OUTPUT_ATLAS);
        File outputFile = new File(concatenatedPath.toAbsolutePath().toString());
        outputAtlas.save(outputFile);
        if (this.optionAndArgumentDelegate.hasVerboseOption()) {
            this.outputDelegate.printlnCommandMessage("saved to " + concatenatedPath.toString());
        }
        return 0;
    }

    @Override
    protected void processAtlas(Atlas atlas, String atlasFileName, File atlasResource) {
        this.atlases.add(atlas);
    }
}

