/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.ChangeBuilder;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.diff.AtlasDiff;
import org.openstreetmap.atlas.geography.atlas.change.serializer.ChangeGeoJsonSerializer;
import org.openstreetmap.atlas.geography.atlas.complete.PrettifyStringFormat;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;

public class AtlasDiffCommand
extends AbstractAtlasShellToolsCommand {
    private static final String BEFORE_ATLAS_ARGUMENT = "before-atlas";
    private static final String AFTER_ATLAS_ARGUMENT = "after-atlas";
    private static final List<String> FORMAT_TYPE_STRINGS = Arrays.stream(PrettifyStringFormat.values()).map(Enum::toString).collect(Collectors.toList());
    private static final PrettifyStringFormat DEFAULT_PRETTY_FEATURE_CHANGE_FORMAT = PrettifyStringFormat.MINIMAL_MULTI_LINE;
    private static final PrettifyStringFormat DEFAULT_PRETTY_COMPLETE_ENTITY_FORMAT = PrettifyStringFormat.MINIMAL_SINGLE_LINE;
    private static final String FEATURE_CHANGE_FORMAT_OPTION_LONG = "feature-change-format";
    private static final String COMPLETE_ENTITY_FORMAT_OPTION_LONG = "complete-entity-format";
    private static final String FEATURE_CHANGE_FORMAT_OPTION_HINT = "format";
    private static final String COMPLETE_ENTITY_FORMAT_OPTION_HINT = "format";
    private static final String FEATURE_CHANGE_FORMAT_OPTION_DESCRIPTION = "The format type for the constituent FeatureChanges. Valid settings are: " + new StringList(FORMAT_TYPE_STRINGS).join(", ") + ". Defaults to " + DEFAULT_PRETTY_FEATURE_CHANGE_FORMAT.toString() + ".";
    private static final String COMPLETE_ENTITY_FORMAT_OPTION_DESCRIPTION = "The format type for the CompleteEntities within the constituent FeatureChanges. Valid settings are: " + new StringList(FORMAT_TYPE_STRINGS).join(", ") + ". Defaults to " + DEFAULT_PRETTY_COMPLETE_ENTITY_FORMAT.toString() + ".";
    private static final String LDGEOJSON_OPTION_LONG = "ldgeojson";
    private static final String LDGEOJSON_OPTION_DESCRIPTION = "Use the line-delimited geoJSON format for output.";
    private static final String GEOJSON_OPTION_LONG = "geojson";
    private static final String GEOJSON_OPTION_DESCRIPTION = "Use the pretty geoJSON format for output.";
    private static final String FULL_OPTION_LONG = "full";
    private static final String FULL_OPTION_DESCRIPTION = "Show the full FeatureChange instead of just the ChangeDescription.";
    private static final List<String> ITEM_TYPE_STRINGS = Arrays.stream(ItemType.values()).map(Enum::toString).collect(Collectors.toList());
    private static final String TYPE_OPTION_LONG = "type";
    private static final String TYPE_OPTION_DESCRIPTION = "The ItemType of the desired feature. Valid types are: " + new StringList(ITEM_TYPE_STRINGS).join(", ") + ".";
    private static final String TYPE_OPTION_HINT = "type";
    private static final String ID_OPTION_LONG = "id";
    private static final String ID_OPTION_DESCRIPTION = "The identifier of the desired feature.";
    private static final String ID_OPTION_HINT = "id";
    private static final Integer LDGEOJSON_CONTEXT = 4;
    private static final Integer GEOJSON_CONTEXT = 5;
    private static final Integer FULL_CONTEXT = 6;
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new AtlasDiffCommand().runSubcommandAndExit(args);
    }

    @Override
    public int execute() {
        Atlas afterAtlas;
        String beforeAtlasPath = this.optionAndArgumentDelegate.getUnaryArgument(BEFORE_ATLAS_ARGUMENT).orElseThrow(AtlasShellToolsException::new);
        String afterAtlasPath = this.optionAndArgumentDelegate.getUnaryArgument(AFTER_ATLAS_ARGUMENT).orElseThrow(AtlasShellToolsException::new);
        File beforeAtlasFile = new File(beforeAtlasPath);
        File afterAtlasFile = new File(afterAtlasPath);
        boolean useGeoJson = false;
        boolean useLdGeoJson = false;
        boolean fullText = false;
        Long selectedIdentifier = null;
        ItemType selectedType = null;
        if (this.optionAndArgumentDelegate.hasOption("id") != this.optionAndArgumentDelegate.hasOption("type")) {
            this.outputDelegate.printlnErrorMessage("options --id and --type must be supplied together or not at all");
            return 2;
        }
        if (this.optionAndArgumentDelegate.hasOption("id")) {
            String idString = this.optionAndArgumentDelegate.getOptionArgument("id").orElseThrow(AtlasShellToolsException::new);
            try {
                selectedIdentifier = Long.parseLong(idString);
            }
            catch (Exception exception) {
                this.outputDelegate.printlnErrorMessage("could not parse id " + idString);
                return 2;
            }
        }
        if (this.optionAndArgumentDelegate.hasOption("type")) {
            String typeString = this.optionAndArgumentDelegate.getOptionArgument("type").orElseThrow(AtlasShellToolsException::new).toUpperCase();
            try {
                selectedType = ItemType.valueOf(typeString);
            }
            catch (Exception exception) {
                this.outputDelegate.printlnErrorMessage("could not parse id " + typeString);
                return 2;
            }
        }
        if (this.optionAndArgumentDelegate.getParserContext() == GEOJSON_CONTEXT.intValue()) {
            useGeoJson = true;
        }
        if (this.optionAndArgumentDelegate.getParserContext() == LDGEOJSON_CONTEXT.intValue()) {
            useLdGeoJson = true;
        }
        if (this.optionAndArgumentDelegate.getParserContext() == FULL_CONTEXT.intValue()) {
            fullText = true;
        }
        if (!beforeAtlasFile.exists()) {
            this.outputDelegate.printlnWarnMessage("file not found: " + beforeAtlasPath);
            return 2;
        }
        if (!afterAtlasFile.exists()) {
            this.outputDelegate.printlnWarnMessage("file not found: " + afterAtlasPath);
            return 2;
        }
        Atlas beforeAtlas = new AtlasResourceLoader().load(beforeAtlasFile);
        AtlasDiff diff = new AtlasDiff(beforeAtlas, afterAtlas = new AtlasResourceLoader().load(afterAtlasFile)).saveAllGeometries(false);
        Optional<Change> changeOptional = diff.generateChange();
        if (changeOptional.isPresent()) {
            Object serializedString;
            Change change = changeOptional.get();
            if (this.optionAndArgumentDelegate.hasOption("id") && this.optionAndArgumentDelegate.hasOption("type")) {
                Optional<FeatureChange> featureChangeOptional = change.changeFor(selectedType, selectedIdentifier);
                if (featureChangeOptional.isPresent()) {
                    change = new ChangeBuilder().add(featureChangeOptional.get()).get();
                } else {
                    this.outputDelegate.printlnWarnMessage("No change found for " + selectedType + " " + selectedIdentifier);
                    return 0;
                }
            }
            if (useGeoJson) {
                serializedString = new ChangeGeoJsonSerializer().convert(change);
            } else if (useLdGeoJson) {
                serializedString = change.toLineDelimitedFeatureChanges();
            } else if (fullText) {
                PrettifyStringFormat featureChangeFormat = this.optionAndArgumentDelegate.getOptionArgument(FEATURE_CHANGE_FORMAT_OPTION_LONG, PrettifyStringFormat::valueOf).orElse(DEFAULT_PRETTY_FEATURE_CHANGE_FORMAT);
                PrettifyStringFormat completeEntityFormat = this.optionAndArgumentDelegate.getOptionArgument(COMPLETE_ENTITY_FORMAT_OPTION_LONG, PrettifyStringFormat::valueOf).orElse(DEFAULT_PRETTY_COMPLETE_ENTITY_FORMAT);
                serializedString = change.prettify(featureChangeFormat, completeEntityFormat, false) + "\n";
            } else {
                StringBuilder builder = new StringBuilder();
                change.changes().forEach(featureChange -> {
                    builder.append(featureChange.explain());
                    builder.append("\n");
                });
                serializedString = builder.toString();
            }
            this.outputDelegate.printlnStdout((String)serializedString, new TTYAttribute[0]);
            return 1;
        }
        this.outputDelegate.printlnWarnMessage("atlases are effectively identical");
        return 0;
    }

    @Override
    public String getCommandName() {
        return "atlas-diff";
    }

    @Override
    public String getSimpleDescription() {
        return "compare two atlas files";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", AtlasDiffCommand.class.getResourceAsStream("AtlasDiffCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", AtlasDiffCommand.class.getResourceAsStream("AtlasDiffCommandExamplesSection.txt"));
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerOptionWithRequiredArgument("type", TYPE_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, "type", 3, GEOJSON_CONTEXT, LDGEOJSON_CONTEXT, FULL_CONTEXT);
        this.registerOptionWithRequiredArgument("id", ID_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, "id", 3, GEOJSON_CONTEXT, LDGEOJSON_CONTEXT, FULL_CONTEXT);
        this.registerOptionWithRequiredArgument(FEATURE_CHANGE_FORMAT_OPTION_LONG, FEATURE_CHANGE_FORMAT_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, "format", FULL_CONTEXT);
        this.registerOptionWithRequiredArgument(COMPLETE_ENTITY_FORMAT_OPTION_LONG, COMPLETE_ENTITY_FORMAT_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, "format", FULL_CONTEXT);
        this.registerOption(LDGEOJSON_OPTION_LONG, LDGEOJSON_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, LDGEOJSON_CONTEXT);
        this.registerOption(GEOJSON_OPTION_LONG, GEOJSON_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, GEOJSON_CONTEXT);
        this.registerOption(FULL_OPTION_LONG, FULL_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, FULL_CONTEXT);
        this.registerArgument(BEFORE_ATLAS_ARGUMENT, ArgumentArity.UNARY, ArgumentOptionality.REQUIRED, 3, LDGEOJSON_CONTEXT, GEOJSON_CONTEXT, FULL_CONTEXT);
        this.registerArgument(AFTER_ATLAS_ARGUMENT, ArgumentArity.UNARY, ArgumentOptionality.REQUIRED, 3, LDGEOJSON_CONTEXT, GEOJSON_CONTEXT, FULL_CONTEXT);
        super.registerOptionsAndArguments();
    }
}

