/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.subcommands;

import com.google.gson.GsonBuilder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.converters.CountryBoundaryMapGeoJsonConverter;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.subcommands.AtlasSearchCommand;
import org.openstreetmap.atlas.utilities.command.subcommands.templates.MultipleOutputCommand;

public class AnyToGeoJsonCommand
extends MultipleOutputCommand {
    private static final String ATLAS_OPTION_LONG = "atlas";
    private static final String ATLAS_OPTION_DESCRIPTION = "The path to an atlas file to be converted.";
    private static final String ATLAS_OPTION_HINT = "atlas-file";
    private static final String SHARDING_OPTION_LONG = "sharding";
    private static final String SHARDING_OPTION_DESCRIPTION = "The sharding to convert, e.g. dynamic@/Users/foo/my-tree.txt";
    private static final String SHARDING_OPTION_HINT = "type@parameter";
    private static final String COUNTRY_BOUNDARY_OPTION_LONG = "country-boundary";
    private static final String COUNTRY_BOUNDARY_OPTION_DESCRIPTION = "The path to a boundary file to be converted.";
    private static final String COUNTRY_BOUNDARY_OPTION_HINT = "boundary-file";
    private static final String COUNTRIES_OPTION_LONG = "countries";
    private static final Character COUNTRIES_OPTION_SHORT = Character.valueOf('c');
    private static final String COUNTRIES_OPTION_DESCRIPTION = "A comma separated list of whitelist country codes to exclusively include. Defaults to all.";
    private static final String COUNTRIES_OPTION_HINT = "included-countries";
    private static final String COUNTRIES_BLACKLIST_OPTION_LONG = "countries-blacklist";
    private static final Character COUNTRIES_BLACKLIST_OPTION_SHORT = Character.valueOf('C');
    private static final String COUNTRIES_BLACKLIST_OPTION_DESCRIPTION = "A comma separated blacklist of country codes to explicitly exclude. Defaults to none.";
    private static final String COUNTRIES_BLACKLIST_OPTION_HINT = "excluded-countries";
    private static final String POLYGONS_OPTION_LONG = "use-polygons";
    private static final Character POLYGONS_OPTION_SHORT = Character.valueOf('p');
    private static final String POLYGONS_OPTION_DESCRIPTION = "Use polygons instead of linestrings for the boundary GeoJSON. This may be better for certain visualization software.";
    private static final Integer ATLAS_CONTEXT = 3;
    private static final Integer SHARDING_CONTEXT = 4;
    private static final Integer BOUNDARY_CONTEXT = 5;
    private static final String OUTPUT_FILE = "output";
    private static final String ATLAS_FILE = "output-atlas" + FileSuffix.GEO_JSON;
    private static final String SHARDING_FILE = "output-sharding" + FileSuffix.GEO_JSON;
    private static final String BOUNDARY_FILE = "output-country-boundary" + FileSuffix.GEO_JSON;
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();

    public static void main(String[] args) {
        new AnyToGeoJsonCommand().runSubcommandAndExit(args);
    }

    @Override
    public int execute() {
        super.execute();
        if (this.optionAndArgumentDelegate.getParserContext() == ATLAS_CONTEXT.intValue()) {
            return this.executeAtlasContext();
        }
        if (this.optionAndArgumentDelegate.getParserContext() == SHARDING_CONTEXT.intValue()) {
            return this.executeShardingContext();
        }
        if (this.optionAndArgumentDelegate.getParserContext() == BOUNDARY_CONTEXT.intValue()) {
            return this.executeBoundaryContext();
        }
        throw new AtlasShellToolsException();
    }

    @Override
    public String getCommandName() {
        return "any2geojson";
    }

    @Override
    public String getSimpleDescription() {
        return "convert a custom file format to GeoJSON";
    }

    @Override
    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", AtlasSearchCommand.class.getResourceAsStream("AnyToGeoJsonCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", AtlasSearchCommand.class.getResourceAsStream("AnyToGeoJsonCommandExamplesSection.txt"));
        super.registerManualPageSections();
    }

    @Override
    public void registerOptionsAndArguments() {
        this.registerOptionWithRequiredArgument(ATLAS_OPTION_LONG, ATLAS_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, ATLAS_OPTION_HINT, ATLAS_CONTEXT);
        this.registerOptionWithRequiredArgument(SHARDING_OPTION_LONG, SHARDING_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, SHARDING_OPTION_HINT, SHARDING_CONTEXT);
        this.registerOptionWithRequiredArgument(COUNTRY_BOUNDARY_OPTION_LONG, COUNTRY_BOUNDARY_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, COUNTRY_BOUNDARY_OPTION_HINT, BOUNDARY_CONTEXT);
        this.registerOptionWithRequiredArgument(COUNTRIES_OPTION_LONG, COUNTRIES_OPTION_SHORT, COUNTRIES_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, COUNTRIES_OPTION_HINT, BOUNDARY_CONTEXT);
        this.registerOptionWithRequiredArgument(COUNTRIES_BLACKLIST_OPTION_LONG, COUNTRIES_BLACKLIST_OPTION_SHORT, COUNTRIES_BLACKLIST_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, COUNTRIES_BLACKLIST_OPTION_HINT, BOUNDARY_CONTEXT);
        this.registerOption(POLYGONS_OPTION_LONG, POLYGONS_OPTION_SHORT, POLYGONS_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, BOUNDARY_CONTEXT);
        super.registerOptionsAndArguments();
    }

    private int executeAtlasContext() {
        File atlasFile = new File(this.optionAndArgumentDelegate.getOptionArgument(ATLAS_OPTION_LONG).orElseThrow(AtlasShellToolsException::new));
        if (!atlasFile.exists()) {
            this.outputDelegate.printlnErrorMessage("file not found: " + atlasFile.getAbsolutePath());
            return 1;
        }
        Atlas atlas = new AtlasResourceLoader().load(atlasFile);
        Path concatenatedPath = Paths.get(this.getOutputPath().toAbsolutePath().toString(), ATLAS_FILE);
        File outputFile = new File(concatenatedPath.toAbsolutePath().toString());
        atlas.saveAsLineDelimitedGeoJsonFeatures(outputFile, (entity, json) -> {});
        return 0;
    }

    private int executeBoundaryContext() {
        Set<String> countries = new HashSet();
        if (this.optionAndArgumentDelegate.hasOption(COUNTRIES_OPTION_LONG)) {
            countries = this.optionAndArgumentDelegate.getOptionArgument(COUNTRIES_OPTION_LONG, this::parseCommaSeparatedCountries).orElse(new HashSet());
        }
        boolean usePolygons = this.optionAndArgumentDelegate.hasOption(POLYGONS_OPTION_LONG);
        HashSet<String> countriesBlacklist = new HashSet();
        if (this.optionAndArgumentDelegate.hasOption(COUNTRIES_BLACKLIST_OPTION_LONG)) {
            countriesBlacklist = this.optionAndArgumentDelegate.getOptionArgument(COUNTRIES_BLACKLIST_OPTION_LONG, this::parseCommaSeparatedCountries).orElse(new HashSet());
        }
        if (this.optionAndArgumentDelegate.hasVerboseOption()) {
            this.outputDelegate.printlnCommandMessage("reading CountryBoundaryMap from file...");
        }
        CountryBoundaryMap map = CountryBoundaryMap.fromPlainText(new File(this.optionAndArgumentDelegate.getOptionArgument(COUNTRY_BOUNDARY_OPTION_LONG).orElseThrow(AtlasShellToolsException::new)));
        String boundaryJson = countries.isEmpty() ? new CountryBoundaryMapGeoJsonConverter().prettyPrint(true).withCountryBlacklist(countriesBlacklist).usePolygons(usePolygons).convertToString(map) : new CountryBoundaryMapGeoJsonConverter().withCountryWhitelist(countries).withCountryBlacklist(countriesBlacklist).prettyPrint(true).usePolygons(usePolygons).convertToString(map);
        if (this.optionAndArgumentDelegate.hasVerboseOption()) {
            this.outputDelegate.printlnCommandMessage("converting boundary file to GeoJSON...");
        }
        if (this.optionAndArgumentDelegate.hasVerboseOption()) {
            this.outputDelegate.printlnCommandMessage("writing the boundary file...");
        }
        Path concatenatedPath = Paths.get(this.getOutputPath().toAbsolutePath().toString(), BOUNDARY_FILE);
        new File(concatenatedPath.toAbsolutePath().toString()).writeAndClose(boundaryJson);
        return 0;
    }

    private int executeShardingContext() {
        Sharding sharding;
        String shardingString = this.optionAndArgumentDelegate.getOptionArgument(SHARDING_OPTION_LONG).orElseThrow(AtlasShellToolsException::new);
        try {
            sharding = Sharding.forString(shardingString);
        }
        catch (Exception exception) {
            this.outputDelegate.printlnErrorMessage(exception.getMessage());
            return 1;
        }
        String shardingJson = new GsonBuilder().setPrettyPrinting().create().toJson(sharding.asGeoJson());
        Path concatenatedPath = Paths.get(this.getOutputPath().toAbsolutePath().toString(), SHARDING_FILE);
        new File(concatenatedPath.toAbsolutePath().toString()).writeAndClose(shardingJson);
        return 0;
    }

    private Set<String> parseCommaSeparatedCountries(String countryString) {
        HashSet<String> countrySet = new HashSet<String>();
        if (countryString.isEmpty()) {
            return countrySet;
        }
        countrySet.addAll(Arrays.stream(countryString.split(",")).collect(Collectors.toSet()));
        return countrySet;
    }
}

