/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command.documentation;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.utilities.command.documentation.DocumentationFormatType;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class DocumentationRegistrar {
    private static final String DESCRIPTION_HEADER = "DESCRIPTION";
    private final Map<String, List<Tuple<DocumentationFormatType, String>>> sections = new LinkedHashMap<String, List<Tuple<DocumentationFormatType, String>>>();

    public void addCodeLineToSection(String section, String codeLine) {
        String capsSection = section.toUpperCase();
        if (!this.sections.containsKey(capsSection)) {
            throw new CoreException("Section {} has not been added", capsSection);
        }
        List<Tuple<DocumentationFormatType, String>> list = this.sections.get(capsSection);
        list.add(new Tuple<DocumentationFormatType, String>(DocumentationFormatType.CODE, codeLine));
    }

    public void addManualPageSection(String section) {
        String capsSection = section.toUpperCase();
        if (this.sections.containsKey(capsSection)) {
            throw new CoreException("Manpage section {} was already added", capsSection);
        }
        this.sections.put(capsSection, new ArrayList());
    }

    public void addManualPageSection(String section, InputStream sectionResourceFileStream) {
        String[] split;
        String capsSection = section.toUpperCase();
        if (this.sections.containsKey(capsSection)) {
            throw new CoreException("Manpage section {} was already added", capsSection);
        }
        StringResource resource = new StringResource();
        resource.copyFrom(new InputStreamResource(() -> sectionResourceFileStream));
        String rawText = resource.all();
        ArrayList<Tuple<DocumentationFormatType, String>> sectionContents = new ArrayList<Tuple<DocumentationFormatType, String>>();
        StringBuilder paragraphBuilder = new StringBuilder();
        for (String line : split = rawText.split(System.getProperty("line.separator"))) {
            if (line.isEmpty()) {
                sectionContents.add(new Tuple<DocumentationFormatType, String>(DocumentationFormatType.PARAGRAPH, paragraphBuilder.toString()));
                paragraphBuilder = new StringBuilder();
                continue;
            }
            if (line.startsWith("#")) {
                sectionContents.add(new Tuple<DocumentationFormatType, String>(DocumentationFormatType.PARAGRAPH, paragraphBuilder.toString()));
                paragraphBuilder = new StringBuilder();
                String scrubbedLine = line.substring(1);
                sectionContents.add(new Tuple<DocumentationFormatType, String>(DocumentationFormatType.CODE, scrubbedLine));
                continue;
            }
            paragraphBuilder.append(line + " ");
        }
        sectionContents.add(new Tuple<DocumentationFormatType, String>(DocumentationFormatType.PARAGRAPH, paragraphBuilder.toString()));
        this.sections.put(capsSection, sectionContents);
    }

    public void addParagraphToSection(String section, String paragraph) {
        String capsSection = section.toUpperCase();
        if (!this.sections.containsKey(capsSection)) {
            throw new CoreException("Section {} has not been added", capsSection);
        }
        List<Tuple<DocumentationFormatType, String>> list = this.sections.get(capsSection);
        list.add(new Tuple<DocumentationFormatType, String>(DocumentationFormatType.PARAGRAPH, paragraph));
    }

    public String getDescriptionHeader() {
        return DESCRIPTION_HEADER;
    }

    public List<Tuple<DocumentationFormatType, String>> getSectionContents(String section) {
        return this.sections.get(section);
    }

    public Set<String> getSections() {
        return this.sections.keySet();
    }

    public boolean hasDescriptionSection() {
        return this.sections.keySet().contains(DESCRIPTION_HEADER);
    }
}

