/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.command;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AtlasShellToolsMarkerInterface;

public final class ReflectionUtilities {
    public static Set<AbstractAtlasShellToolsCommand> getSubcommandInstances() {
        ArrayList subcommandClasses = new ArrayList();
        HashSet<AbstractAtlasShellToolsCommand> instantiatedCommands = new HashSet<AbstractAtlasShellToolsCommand>();
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().scan();){
            ClassInfoList classInfoList = scanResult.getClassesImplementing(AtlasShellToolsMarkerInterface.class.getName());
            classInfoList.loadClasses().forEach(klass -> subcommandClasses.add(klass));
        }
        subcommandClasses.stream().forEach(klass -> ReflectionUtilities.instantiateSubcommand(klass.getName()).ifPresent(instantiatedCommands::add));
        return instantiatedCommands;
    }

    private static Optional<AbstractAtlasShellToolsCommand> instantiateSubcommand(String classname) {
        AbstractAtlasShellToolsCommand subcommand;
        Constructor<?> constructor;
        Class<?> subcommandClass;
        try {
            subcommandClass = Class.forName(classname);
        }
        catch (ClassNotFoundException exception) {
            throw new CoreException("Class {} was not found", classname, exception);
        }
        if (Modifier.isAbstract(subcommandClass.getModifiers())) {
            return Optional.empty();
        }
        try {
            constructor = subcommandClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            throw new CoreException("Class {} does not have a matching constructor", classname, exception);
        }
        catch (SecurityException exception) {
            throw new CoreException("Error instantiating class {}", classname, exception);
        }
        try {
            subcommand = (AbstractAtlasShellToolsCommand)constructor.newInstance(new Object[0]);
        }
        catch (ClassCastException exception) {
            throw new CoreException("Class {} not a subtype of {}", classname, AbstractAtlasShellToolsCommand.class.getName(), exception);
        }
        catch (Exception exception) {
            throw new CoreException("Error instantiating class {}", classname, exception);
        }
        return Optional.of(subcommand);
    }

    private ReflectionUtilities() {
    }
}

