/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.index.RTree;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.utilities.scalars.Counter;

public abstract class ShardBucketCollection<LocatedType extends Located & Serializable, CollectionType extends Collection<LocatedType> & Serializable>
implements Collection<LocatedType>,
Serializable {
    private static final long serialVersionUID = -7892704554302160820L;
    private final CollectionType[] collectionBuckets;
    private final RTree<ShardToCollectionIndex> collectionIndex;
    private final HashMap<Shard, ShardToCollectionIndex> initializedShards = new HashMap();
    private final Rectangle maximumBounds;

    public ShardBucketCollection(Rectangle maximumBounds, Integer zoomLevel) {
        this(maximumBounds, SlippyTile.allTiles(zoomLevel, maximumBounds));
    }

    public ShardBucketCollection(Rectangle maximumBounds, Sharding sharding) {
        this(maximumBounds, sharding.shards(maximumBounds));
    }

    private ShardBucketCollection(Rectangle maximumBounds, Iterable<? extends Shard> shards) {
        this.maximumBounds = maximumBounds;
        this.collectionIndex = new RTree();
        Counter counter = new Counter();
        shards.forEach(shardBucket -> {
            ShardToCollectionIndex shardToCollectionIndex = new ShardToCollectionIndex((int)counter.getValueAndIncrement(), (Shard)shardBucket);
            this.collectionIndex.add(shardToCollectionIndex.bounds(), shardToCollectionIndex);
        });
        this.collectionBuckets = (Collection[])Array.newInstance(this.initializeBucketCollection().getClass(), (int)counter.getValue());
    }

    @Override
    public final boolean add(LocatedType item) {
        if (Objects.nonNull(item) && item.bounds().overlaps(this.maximumBounds)) {
            List<ShardToCollectionIndex> indexes = this.collectionIndex.get(item.bounds());
            if (indexes.size() == 1) {
                return this.addFunction(item, this.getOrCreateBucketCollectionAt(indexes.get(0)), indexes.get(0).getShard());
            }
            if (this.allowMultipleBucketInsertion()) {
                long addedAmount = indexes.stream().filter(index -> this.addFunction(item, this.getOrCreateBucketCollectionAt((ShardToCollectionIndex)index), index.getShard())).count();
                return addedAmount > 0L;
            }
            Shard toInsertAt = this.resolveShard(item, indexes.stream().map(ShardToCollectionIndex::getShard).collect(Collectors.toList()));
            Optional<ShardToCollectionIndex> toAddTo = indexes.stream().filter(index -> toInsertAt.equals(index.getShard())).findFirst();
            return toAddTo.map(index -> this.addFunction(item, this.getOrCreateBucketCollectionAt((ShardToCollectionIndex)index), index.getShard())).orElse(false);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends LocatedType> collection) {
        if (Objects.nonNull(collection)) {
            long addCount = collection.stream().filter(this::add).count();
            return addCount > 0L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        CollectionType[] CollectionTypeArray = this.collectionBuckets;
        synchronized (this.collectionBuckets) {
            for (int i = 0; i < this.collectionBuckets.length; ++i) {
                this.collectionBuckets[i] = null;
            }
            this.initializedShards.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean contains(Object object) {
        Optional<LocatedType> typedItem = this.castToLocatedType(object);
        if (typedItem.isPresent()) {
            Located item = (Located)typedItem.get();
            return this.getBucketCollectionsForBounds(item.bounds()).anyMatch(collection -> collection.contains(item));
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (Objects.nonNull(collection)) {
            return collection.stream().allMatch(this::contains);
        }
        return false;
    }

    public Stream<LocatedType> distinctStream() {
        return this.stream().distinct();
    }

    public Stream<CollectionType> getAllBucketCollections() {
        return Arrays.stream(this.collectionBuckets).filter(x$0 -> Objects.nonNull(x$0));
    }

    public Map<Shard, CollectionType> getAllShardBucketCollectionPairs() {
        return this.initializedShards.values().stream().collect(Collectors.toMap(ShardToCollectionIndex::getShard, this::getCollectionAt));
    }

    public Optional<CollectionType> getBucketCollectionForShard(Shard shard) {
        return Optional.ofNullable(this.initializedShards.get(shard)).map(this::getCollectionAt).filter(x$0 -> Objects.nonNull(x$0));
    }

    public Stream<CollectionType> getBucketCollectionsForBounds(Rectangle bounds) {
        return this.collectionIndex.get(bounds).stream().map(this::getCollectionAt).filter(x$0 -> Objects.nonNull(x$0));
    }

    public Rectangle getMaximumBounds() {
        return this.maximumBounds;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<LocatedType> iterator() {
        return this.stream().iterator();
    }

    @Override
    public boolean remove(Object object) {
        Located item;
        Optional<LocatedType> typedItem = this.castToLocatedType(object);
        if (typedItem.isPresent() && (item = (Located)typedItem.get()).bounds().overlaps(this.maximumBounds)) {
            long removeCount = this.getBucketCollectionsForBounds(item.bounds()).filter(collection -> collection.remove(item)).count();
            return removeCount > 0L;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (Objects.nonNull(collection)) {
            long removeCount = collection.stream().filter(this::remove).count();
            return removeCount > 0L;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        List toRemove = this.stream().filter(item -> !collection.contains(item)).collect(Collectors.toList());
        return this.removeAll(toRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        CollectionType[] CollectionTypeArray = this.collectionBuckets;
        synchronized (this.collectionBuckets) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getAllBucketCollections().mapToInt(rec$ -> ((Collection)rec$).size()).sum();
        }
    }

    @Override
    public Stream<LocatedType> stream() {
        return this.getAllBucketCollections().flatMap(rec$ -> ((Collection)rec$).stream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] toReturn = new Object[]{};
        CollectionType[] CollectionTypeArray = this.collectionBuckets;
        synchronized (this.collectionBuckets) {
            Iterator bucketIterator = this.getAllBucketCollections().iterator();
            while (bucketIterator.hasNext()) {
                toReturn = ArrayUtils.addAll(toReturn, ((Collection)bucketIterator.next()).toArray());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return toReturn;
        }
    }

    @Override
    public <T1> T1[] toArray(T1[] otherArray) {
        return ArrayUtils.addAll(otherArray, this.toArray());
    }

    protected boolean addFunction(LocatedType item, CollectionType collection, Shard shard) {
        return collection.add(item);
    }

    protected abstract boolean allowMultipleBucketInsertion();

    protected abstract CollectionType initializeBucketCollection();

    protected Shard resolveShard(LocatedType item, List<? extends Shard> possibleBuckets) {
        throw new UnsupportedOperationException("Implement this method when not allowing multiple bucket insertion");
    }

    private Optional<LocatedType> castToLocatedType(Object object) {
        try {
            return Optional.ofNullable(object).map(cast -> (Located)cast);
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBucketCollectionAt(ShardToCollectionIndex index) {
        CollectionType[] CollectionTypeArray = this.collectionBuckets;
        synchronized (this.collectionBuckets) {
            if (Objects.isNull(this.collectionBuckets[index.getIndex()])) {
                this.collectionBuckets[index.getIndex()] = this.initializeBucketCollection();
                this.initializedShards.put(index.getShard(), index);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionType getCollectionAt(ShardToCollectionIndex index) {
        CollectionType[] CollectionTypeArray = this.collectionBuckets;
        synchronized (this.collectionBuckets) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.collectionBuckets[index.getIndex()];
        }
    }

    private CollectionType getOrCreateBucketCollectionAt(ShardToCollectionIndex index) {
        CollectionType collection = this.getCollectionAt(index);
        if (Objects.isNull(collection)) {
            this.createBucketCollectionAt(index);
            return this.getCollectionAt(index);
        }
        return collection;
    }

    private static class ShardToCollectionIndex
    implements Located,
    Serializable {
        private static final long serialVersionUID = 4050100671815503794L;
        private final int index;
        private final Shard shard;

        ShardToCollectionIndex(int index, Shard shard) {
            this.index = index;
            this.shard = shard;
        }

        @Override
        public Rectangle bounds() {
            return this.getShard().bounds();
        }

        public int getIndex() {
            return this.index;
        }

        public Shard getShard() {
            return this.shard;
        }
    }
}

