/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class ImmutableListCollector<T extends Comparable<T>>
implements Collector<T, ImmutableList.Builder<T>, ImmutableList<T>> {
    @Override
    public BiConsumer<ImmutableList.Builder<T>, T> accumulator() {
        return (builder, item) -> builder.add(item);
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return ImmutableSet.of(Collector.Characteristics.UNORDERED);
    }

    @Override
    public BinaryOperator<ImmutableList.Builder<T>> combiner() {
        return (builder1, builder2) -> {
            builder1.addAll((Iterable)builder2.build());
            return builder1;
        };
    }

    @Override
    public Function<ImmutableList.Builder<T>, ImmutableList<T>> finisher() {
        return builder -> builder.build();
    }

    @Override
    public Supplier<ImmutableList.Builder<T>> supplier() {
        return ImmutableList::builder;
    }
}

