/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.collections;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.openstreetmap.atlas.exception.CoreException;

public abstract class EnumSetCollector<T extends Enum<T>>
implements Collector<String, Set<String>, EnumSet<T>> {
    private Class enumClass;
    private Method valueOfMethod;

    protected EnumSetCollector() {
        TypeToken<?> resolver = TypeToken.of(this.getClass());
        for (TypeVariable typeVariable : EnumSetCollector.class.getTypeParameters()) {
            TypeToken<?> currentToken = resolver.resolveType(typeVariable);
            this.enumClass = currentToken.getRawType();
            try {
                this.valueOfMethod = this.enumClass.getMethod("valueOf", String.class);
            }
            catch (NoSuchMethodException oops) {
                throw new CoreException(String.format("%s isn't a Java enum", this.enumClass.getName()));
            }
        }
    }

    @Override
    public BiConsumer<Set<String>, String> accumulator() {
        return (enumset, value) -> enumset.add(value.toUpperCase());
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.UNORDERED);
    }

    @Override
    public BinaryOperator<Set<String>> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<Set<String>, EnumSet<T>> finisher() {
        return working -> {
            if (working.contains("ALL")) {
                return EnumSet.allOf(this.enumClass);
            }
            try {
                EnumSet<Enum> returnValue = EnumSet.noneOf(this.enumClass);
                for (String constant : working) {
                    returnValue.add((Enum)this.valueOfMethod.invoke(null, constant));
                }
                return returnValue;
            }
            catch (IllegalAccessException | InvocationTargetException oops) {
                throw new CoreException("Can't find enum value for: {}", working);
            }
        };
    }

    @Override
    public Supplier<Set<String>> supplier() {
        return this.enumClass == null ? null : () -> new HashSet();
    }
}

