/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations.base;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperationResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHOperation {
    private static final Logger logger = LoggerFactory.getLogger(SSHOperation.class);
    private static final String LOGIN_FORMAT = "%s@%s";
    private static final String SSH_COMMAND = "ssh";
    private static final String DISABLE_STRICT_HOST_CHECKING = "-oStrictHostKeyChecking=no";
    private static final String QUIET_MODE = "-q";
    private static final String PORT_OVERRIDE = "-p";
    private final List<String> args = new ArrayList<String>();
    private String hostname;
    private String username;
    private Optional<Integer> possiblePort = Optional.empty();
    private boolean debug;

    public SSHOperation addArgs(String ... args) {
        if (args == null || args.length == 0) {
            return this;
        }
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public SSHOperation asUser(String username) {
        this.username = username;
        return this;
    }

    public SSHOperation enableDebug() {
        this.debug = true;
        return this;
    }

    public SSHOperationResults execute() throws IOException, InterruptedException {
        if (this.hostname == null) {
            throw new IllegalStateException("Hostname must be defined");
        }
        if (this.username == null) {
            this.username = System.getProperty("user.name");
        }
        List<String> arguments = this.buildArguments();
        ProcessBuilder builder = new ProcessBuilder(arguments);
        if (this.debug) {
            logger.debug(Joiner.on(" ").join(arguments));
        }
        builder.redirectErrorStream(true);
        SSHOperationResults results = new SSHOperationResults();
        Process process = builder.start();
        String remoteOutput = new String(IOUtils.toByteArray(process.getInputStream()));
        int returnCode = process.waitFor();
        if (this.debug) {
            logger.debug("[{}] with output:\n{}", (Object)returnCode, (Object)remoteOutput);
        }
        return results.finish(remoteOutput, returnCode);
    }

    public String getHost() {
        return this.hostname;
    }

    public String getUser() {
        return this.username;
    }

    public SSHOperation onHost(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public SSHOperation onPort(int port) {
        this.possiblePort = Optional.of(port);
        return this;
    }

    private List<String> buildArguments() {
        if (this.args.size() == 0) {
            throw new IllegalStateException("You must have at least one argument");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(SSH_COMMAND);
        arguments.add(DISABLE_STRICT_HOST_CHECKING);
        arguments.add(QUIET_MODE);
        this.possiblePort.ifPresent(port -> {
            arguments.add(PORT_OVERRIDE);
            arguments.add(String.valueOf(port));
        });
        arguments.add(String.format(LOGIN_FORMAT, this.username, this.hostname));
        arguments.addAll(this.args);
        return arguments;
    }
}

