/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations;

import java.io.IOException;
import java.nio.file.Path;
import org.openstreetmap.atlas.utilities.cli.operations.AbstractOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperationResults;

public class RMDirOperation
extends AbstractOperation {
    @Override
    public RMDirOperation asUser(String username) {
        super.asUser(username);
        return this;
    }

    @Override
    public RMDirOperation onHost(String host) {
        super.onHost(host);
        return this;
    }

    @Override
    public RMDirOperation onPort(int portNumber) {
        super.onPort(portNumber);
        return this;
    }

    public boolean rmdir(Path remotePath) throws InterruptedException, IOException {
        if (remotePath == null) {
            throw new IllegalArgumentException("remotePath can't be null");
        }
        if (remotePath.toString().contains("*")) {
            throw new IllegalArgumentException("Please, be careful with the asterisks");
        }
        this.ssh().addArgs("rm", "-rf", remotePath.toString());
        SSHOperationResults results = this.handleResults(this.ssh().execute());
        return results.getReturnValue() == 0;
    }
}

