/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.utilities.cli.operations.AbstractHDFSOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperationResults;

public class HDFSCatOperation
extends AbstractHDFSOperation {
    @Override
    public HDFSCatOperation asUser(String username) {
        super.asUser(username);
        return this;
    }

    public SSHOperationResults cat(String ... paths) throws InterruptedException, IOException {
        if (paths.length == 0) {
            throw new IllegalArgumentException("source can't be null");
        }
        String pathsAsString = Arrays.asList(paths).stream().map(this::preparePath).collect(Collectors.joining(" "));
        this.prepareSSH().addArgs("-cat", pathsAsString);
        return this.handleResults(this.ssh().execute());
    }

    @Override
    public HDFSCatOperation onHost(String host) {
        super.onHost(host);
        return this;
    }

    @Override
    public HDFSCatOperation onPort(int portNumber) {
        super.onPort(portNumber);
        return this;
    }

    @Override
    public HDFSCatOperation withConfiguration(String configuration) {
        super.withConfiguration(configuration);
        return this;
    }
}

