/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.StringList;

public class ArrangementCheck
extends AbstractCheck {
    private ObjectTypeComparator objectTypeComparator;
    private String arrangementDefinition = "";

    public static Optional<DetailAST> findFirstToken(DetailAST source, int tokenType) {
        return Optional.ofNullable(source.findFirstToken(tokenType));
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 154, 9, 10, 8, 15, 12, 11};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void setArrangementDefinition(String arrangementDefinition) {
        this.arrangementDefinition = arrangementDefinition;
    }

    @Override
    public void visitToken(DetailAST object) {
        DetailAST nextSiblingGet;
        ObjectType right;
        ObjectType left = new ObjectType(object);
        if (!this.acceptedTokens().contains(object.getType()) || !this.getObjectTypeComparator().isComparable(left)) {
            return;
        }
        Optional<DetailAST> nextSibling = Optional.ofNullable(object.getNextSibling());
        while (!(!nextSibling.isPresent() || this.acceptedTokens().contains(nextSibling.get().getType()) && this.getObjectTypeComparator().isComparable(new ObjectType(nextSibling.get())))) {
            nextSibling = Optional.ofNullable(nextSibling.get().getNextSibling());
        }
        if (nextSibling.isPresent() && left.compareTo(right = new ObjectType(nextSiblingGet = nextSibling.get())) > 0) {
            Object moreInfo = "";
            if (!left.getName().isEmpty()) {
                moreInfo = (String)moreInfo + ", " + left.getName();
            }
            if (!right.getName().isEmpty()) {
                moreInfo = (String)moreInfo + ", " + right.getName();
            }
            this.log(nextSiblingGet.getLineNo(), "Invalid order" + (String)moreInfo, new Object[0]);
        }
    }

    private Set<Integer> acceptedTokens() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int value : this.getAcceptableTokens()) {
            result.add(value);
        }
        return result;
    }

    private ObjectTypeComparator getObjectTypeComparator() {
        if (this.objectTypeComparator == null) {
            if (this.arrangementDefinition.isEmpty()) {
                this.objectTypeComparator = new ObjectTypeComparator();
            } else if (this.arrangementDefinition.startsWith("/")) {
                this.objectTypeComparator = new ObjectTypeComparator(new File(this.arrangementDefinition));
            } else {
                throw new CoreException("Invalid configuration for ArrangementCheck: {}", this.arrangementDefinition);
            }
        }
        return this.objectTypeComparator;
    }

    private class ObjectTypeComparator
    implements Comparator<ObjectType> {
        private static final int ARRANGEMENT_LINE_SIZE = 3;
        private static final String ARRANGEMENT_FILE = "arrangement.txt";
        private final Map<ObjectRawType, Integer> rawTypeToOrderIndex;

        ObjectTypeComparator() {
            this(new InputStreamResource(() -> ArrangementCheck.class.getResourceAsStream(ARRANGEMENT_FILE)));
        }

        ObjectTypeComparator(Resource ordering) {
            int index = 0;
            try {
                this.rawTypeToOrderIndex = new HashMap<ObjectRawType, Integer>();
                for (String line : ordering.lines()) {
                    StringList split = StringList.split(line, ",");
                    if (line.isEmpty() || line.startsWith("#")) {
                        ++index;
                        continue;
                    }
                    if (split.size() != 3) {
                        throw new CoreException("Malformed line: \"{}\"", line);
                    }
                    Type type = Type.forName(split.get(0));
                    Visibility visibility = Visibility.forName(split.get(1));
                    boolean isStatic = "static".equalsIgnoreCase(split.get(2));
                    this.rawTypeToOrderIndex.put(new ObjectRawType(visibility, type, isStatic), index);
                    ++index;
                }
            }
            catch (Exception e) {
                throw new CoreException("Unable to parse file defining arrangement (was at line {}): {}", index + 1, ArrangementCheck.class.getResource(ARRANGEMENT_FILE).getPath(), e);
            }
        }

        @Override
        public int compare(ObjectType left, ObjectType right) {
            int difference = this.rawTypeToOrderIndex.get(left.getObjectRawType()) - this.rawTypeToOrderIndex.get(right.getObjectRawType());
            if (difference == 0 && Type.FIELD != left.getObjectRawType().getType()) {
                String leftName = left.getName();
                String rightName = right.getName();
                return leftName.compareTo(rightName);
            }
            return difference;
        }

        public boolean isComparable(ObjectType object) {
            return this.rawTypeToOrderIndex.containsKey(object.getObjectRawType()) && !"serialVersionUID".equals(object.getName());
        }
    }

    private class ObjectType
    implements Comparable<ObjectType> {
        private final ObjectRawType objectRawType;
        private final String name;

        ObjectType(DetailAST object) {
            boolean isStatic;
            Visibility visibility;
            Type type = Type.forType(object.getType());
            Optional<DetailAST> ident = ArrangementCheck.findFirstToken(object, 58);
            this.name = ident.isPresent() ? ident.get().getText() : (Type.INITIALIZER_BLOCK == type || Type.STATIC_INITIALIZER_BLOCK == type ? type.name().toLowerCase() : "");
            Optional<DetailAST> modifiers = ArrangementCheck.findFirstToken(object, 5);
            if (modifiers.isPresent()) {
                visibility = ArrangementCheck.findFirstToken(modifiers.get(), 61).isPresent() ? Visibility.PRIVATE : (ArrangementCheck.findFirstToken(modifiers.get(), 63).isPresent() ? Visibility.PROTECTED : (ArrangementCheck.findFirstToken(modifiers.get(), 62).isPresent() ? Visibility.PUBLIC : Visibility.PACKAGE_PRIVATE));
                isStatic = ArrangementCheck.findFirstToken(modifiers.get(), 64).isPresent();
            } else {
                visibility = Visibility.PACKAGE_PRIVATE;
                isStatic = false;
            }
            this.objectRawType = new ObjectRawType(visibility, type, isStatic);
        }

        @Override
        public int compareTo(ObjectType that) {
            return ArrangementCheck.this.getObjectTypeComparator().compare(this, that);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ObjectType that = (ObjectType)other;
            return this.getObjectRawType().equals(that.getObjectRawType()) && this.getName().equals(that.getName());
        }

        public String getName() {
            return this.name;
        }

        public ObjectRawType getObjectRawType() {
            return this.objectRawType;
        }

        public Type getType() {
            return this.objectRawType.getType();
        }

        public Visibility getVisibility() {
            return this.objectRawType.getVisibility();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getVisibility(), this.getType(), this.isStatic(), this.getName()});
        }

        public boolean isStatic() {
            return this.objectRawType.isStatic();
        }

        public String toString() {
            return "ObjectType{visibility=" + this.getVisibility() + ", type=" + this.getType() + ", isStatic=" + this.isStatic() + ", name='" + this.name + "'}";
        }
    }

    private class ObjectRawType {
        private final Visibility visibility;
        private final Type type;
        private final boolean isStatic;

        ObjectRawType(Visibility visibility, Type type, boolean isStatic) {
            this.visibility = visibility;
            this.type = type;
            this.isStatic = isStatic;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ObjectRawType that = (ObjectRawType)other;
            return this.isStatic() == that.isStatic() && this.getVisibility() == that.getVisibility() && this.getType() == that.getType();
        }

        public Type getType() {
            return this.type;
        }

        public Visibility getVisibility() {
            return this.visibility;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getVisibility(), this.getType(), this.isStatic()});
        }

        public boolean isStatic() {
            return this.isStatic;
        }
    }

    private static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE_PRIVATE,
        PRIVATE;


        public static Visibility forName(String name) {
            for (Visibility visibility : Visibility.values()) {
                if (!visibility.name().equalsIgnoreCase(name)) continue;
                return visibility;
            }
            if (name.isEmpty()) {
                return PACKAGE_PRIVATE;
            }
            throw new CoreException("Invalid name \"{}\"", name);
        }
    }

    private static enum Type {
        INTERFACE(15),
        ENUM(154),
        CLASS(14),
        FIELD(10),
        STATIC_INITIALIZER_BLOCK(12),
        INITIALIZER_BLOCK(11),
        METHOD(9),
        CONSTRUCTOR(8);

        private final int tokenType;

        public static Type forName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            throw new CoreException("Invalid name {}", name);
        }

        public static Type forType(int tokenType) {
            for (Type type : Type.values()) {
                if (type.tokenType != tokenType) continue;
                return type;
            }
            throw new CoreException("Invalid token type {}", tokenType);
        }

        private Type(int tokenType) {
            this.tokenType = tokenType;
        }
    }
}

