/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.caching.strategies;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.openstreetmap.atlas.streaming.resource.ByteArrayResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.strategies.AbstractCachingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayCachingStrategy
extends AbstractCachingStrategy {
    private static final long DEFAULT_BYTE_ARRAY_SIZE = 0x200000L;
    private static final Logger logger = LoggerFactory.getLogger(ByteArrayCachingStrategy.class);
    private final Map<UUID, ByteArrayResource> resourceCache = new HashMap<UUID, ByteArrayResource>();
    private long initialArraySize = 0x200000L;
    private boolean useExactResourceSize = false;

    @Override
    public Optional<Resource> attemptFetch(URI resourceURI, Function<URI, Optional<Resource>> defaultFetcher) {
        UUID resourceUUID = this.getUUIDForResourceURI(resourceURI);
        if (!this.resourceCache.containsKey(resourceUUID)) {
            ByteArrayResource resourceBytes;
            logger.trace("StrategyID {}: attempting to cache resource {} in byte array keyed on UUID {}", new Object[]{this.getStrategyID(), resourceURI, resourceUUID.toString()});
            Optional<Resource> resource = defaultFetcher.apply(resourceURI);
            if (!resource.isPresent()) {
                logger.warn("StrategyID {}: application of default fetcher for {} returned empty Optional!", (Object)this.getStrategyID(), (Object)resourceURI);
                return Optional.empty();
            }
            if (this.useExactResourceSize) {
                long resourceLength = resource.get().length();
                logger.trace("StrategyID {}: using extact resource length {}", (Object)this.getStrategyID(), (Object)resourceLength);
                resourceBytes = new ByteArrayResource(resourceLength);
            } else {
                logger.trace("StrategyID {}: using initial array size {}", (Object)this.getStrategyID(), (Object)this.initialArraySize);
                resourceBytes = new ByteArrayResource(this.initialArraySize);
            }
            resourceBytes.writeAndClose(resource.get().readBytesAndClose());
            this.resourceCache.put(resourceUUID, resourceBytes);
        }
        logger.trace("StrategyID {}: returning cached resource {} from byte array keyed on UUID {}", new Object[]{this.getStrategyID(), resourceURI, resourceUUID.toString()});
        return Optional.of((Resource)this.resourceCache.get(resourceUUID));
    }

    @Override
    public String getName() {
        return "ByteArrayCachingStrategy";
    }

    @Override
    public void invalidate() {
        this.resourceCache.clear();
    }

    @Override
    public void invalidate(URI resourceURI) {
        UUID resourceUUID = this.getUUIDForResourceURI(resourceURI);
        this.resourceCache.remove(resourceUUID);
    }

    public ByteArrayCachingStrategy useExactResourceSize() {
        this.useExactResourceSize = true;
        return this;
    }

    public ByteArrayCachingStrategy withInitialArraySize(long initialSize) {
        this.initialArraySize = initialSize;
        return this;
    }
}

