/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.caching.strategies;

import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.openstreetmap.atlas.utilities.caching.strategies.CachingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCachingStrategy
implements CachingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCachingStrategy.class);
    private final Map<String, UUID> uriStringToUUIDCache = new ConcurrentHashMap<String, UUID>();
    private final UUID strategyID = UUID.randomUUID();

    public AbstractCachingStrategy() {
        logger.info("Initialized strategy {} with ID {}", (Object)this.getClass().getName(), (Object)this.strategyID);
    }

    protected UUID getStrategyID() {
        return this.strategyID;
    }

    protected UUID getUUIDForResourceURI(URI resourceURI) {
        String uriString = resourceURI.toString();
        if (!this.uriStringToUUIDCache.containsKey(uriString)) {
            UUID newUUID = UUID.nameUUIDFromBytes(uriString.getBytes());
            this.uriStringToUUIDCache.put(uriString, newUUID);
            return newUUID;
        }
        return this.uriStringToUUIDCache.get(uriString);
    }
}

