/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.caching;

import java.nio.file.Paths;
import java.util.Optional;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.ConcurrentResourceCache;
import org.openstreetmap.atlas.utilities.caching.strategies.ByteArrayCachingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileInMemoryCache
extends ConcurrentResourceCache {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileInMemoryCache.class);

    public LocalFileInMemoryCache() {
        super(new ByteArrayCachingStrategy(), uri -> {
            File file = new File(uri.getPath());
            if (!file.exists()) {
                logger.warn("File {} does not exist!", (Object)file);
                return Optional.empty();
            }
            return Optional.of(file);
        });
    }

    @Override
    public Optional<Resource> get(String path) {
        return this.get(Paths.get(path, new String[0]).toAbsolutePath().toUri());
    }
}

