/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.caching;

import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.ResourceCache;
import org.openstreetmap.atlas.utilities.caching.strategies.CachingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentResourceCache
implements ResourceCache {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentResourceCache.class);
    private final CachingStrategy cachingStrategy;
    private final Function<URI, Optional<Resource>> fetcher;
    private final UUID cacheID;

    public ConcurrentResourceCache(CachingStrategy cachingStrategy, Function<URI, Optional<Resource>> fetcher) {
        this.cachingStrategy = cachingStrategy;
        this.fetcher = fetcher;
        this.cacheID = UUID.randomUUID();
        logger.info("Initialized cache {} with ID {}", (Object)this.getClass().getName(), (Object)this.cacheID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Resource> get(URI resourceURI) {
        Optional<Resource> cachedResource;
        ConcurrentResourceCache concurrentResourceCache = this;
        synchronized (concurrentResourceCache) {
            cachedResource = this.cachingStrategy.attemptFetch(resourceURI, this.fetcher);
        }
        if (!cachedResource.isPresent()) {
            logger.warn("CacheID {}: cache fetch of {} failed, falling back to default fetcher...", (Object)this.cacheID, (Object)resourceURI);
            concurrentResourceCache = this;
            synchronized (concurrentResourceCache) {
                cachedResource = this.fetcher.apply(resourceURI);
            }
        }
        return cachedResource;
    }

    public String getStrategyName() {
        return this.cachingStrategy.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        logger.info("CacheID {}: invalidating cache", (Object)this.cacheID);
        ConcurrentResourceCache concurrentResourceCache = this;
        synchronized (concurrentResourceCache) {
            this.cachingStrategy.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(URI resourceURI) {
        logger.info("CacheID {}: invalidating resource {}", (Object)this.cacheID, (Object)resourceURI);
        ConcurrentResourceCache concurrentResourceCache = this;
        synchronized (concurrentResourceCache) {
            this.cachingStrategy.invalidate(resourceURI);
        }
    }

    protected UUID getCacheID() {
        return this.cacheID;
    }
}

