/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.archive;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveException;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.archive.Extractor;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class UnzipperCommand
extends Command {
    private static final Command.Switch<Path> OUTPUT_FILE_PARAMETER = new Command.Switch("output", "Output directory to store zip file entries", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private static final Command.Switch<Path> INPUT_ZIP_FILE_PARAMETER = new Command.Switch("zip", "Zip file to extract all of the data", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);

    public static void main(String ... args) {
        new UnzipperCommand().runWithoutQuitting(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        Path inputPath = this.prepareInput((Path)command.get(INPUT_ZIP_FILE_PARAMETER));
        Path outputFile = this.prepareOutput((Path)command.get(OUTPUT_FILE_PARAMETER));
        try {
            Extractor.extractZipArchive(outputFile).extract(inputPath);
        }
        catch (IOException | ArchiveException oops) {
            throw new CoreException("Error when extracting: {} -> {}", inputPath, outputFile, oops);
        }
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(OUTPUT_FILE_PARAMETER, INPUT_ZIP_FILE_PARAMETER);
    }

    private Path prepareInput(Path inputPath) {
        if (!Files.isReadable(inputPath)) {
            throw new CoreException("Can't read {} or it doesn't exist", inputPath);
        }
        return inputPath;
    }

    private Path prepareOutput(Path outputFile) {
        if (Files.exists(outputFile, new LinkOption[0]) && !Files.isDirectory(outputFile, new LinkOption[0])) {
            throw new CoreException("{} already exists and is not a directory", outputFile);
        }
        try {
            Files.createDirectories(outputFile, new FileAttribute[0]);
        }
        catch (IOException oops) {
            throw new CoreException("Can't create {}", outputFile, oops);
        }
        return outputFile;
    }
}

