/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.archive;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openstreetmap.atlas.utilities.archive.ArchiveVetoDelegate;
import org.openstreetmap.atlas.utilities.archive.ArchiverEventListener;

abstract class AbstractArchiverOrExtractor<T> {
    private final Collection<ArchiverEventListener<T>> listeners;
    private final Class<T> klass;
    private ArchiveVetoDelegate<T> delegate;

    protected AbstractArchiverOrExtractor(Class<T> klass) {
        this.klass = klass;
        this.listeners = new CopyOnWriteArraySet<ArchiverEventListener<T>>();
    }

    public AbstractArchiverOrExtractor<T> addArchiverEventListener(ArchiverEventListener<T> listener) {
        this.listeners.add(listener);
        return this;
    }

    public AbstractArchiverOrExtractor<T> removeArchiverEventListener(ArchiverEventListener<T> listener) {
        this.listeners.remove(listener);
        return this;
    }

    public AbstractArchiverOrExtractor<T> setVetoDelegate(ArchiveVetoDelegate<T> delegate) {
        this.delegate = delegate;
        return this;
    }

    protected void fireArchiveCompleted() {
        for (ArchiverEventListener<T> listener : this.listeners) {
            listener.archiveCompleted(this.klass.cast(this));
        }
    }

    protected void fireArchiveFailed() {
        for (ArchiverEventListener<T> listener : this.listeners) {
            listener.archiveFailed(this.klass.cast(this));
        }
    }

    protected void fireArchiveStarted() {
        for (ArchiverEventListener<T> listener : this.listeners) {
            listener.archiveStarted(this.klass.cast(this));
        }
    }

    protected void fireItemCompleted(File file) {
        for (ArchiverEventListener<T> listener : this.listeners) {
            listener.itemCompleted(this.klass.cast(this), file);
        }
    }

    protected void fireItemFailed(File file, IOException oops) {
        for (ArchiverEventListener<T> listener : this.listeners) {
            listener.itemFailed(this.klass.cast(this), file, oops);
        }
    }

    protected void fireItemInProgress(File file, long count, long length) {
        for (ArchiverEventListener<T> listener : this.listeners) {
            listener.itemInProgress(this.klass.cast(this), file, count, length);
        }
    }

    protected void fireItemSkipped(File file) {
        for (ArchiverEventListener<T> listener : this.listeners) {
            listener.itemSkipped(this.klass.cast(this), file);
        }
    }

    protected void fireItemStarted(File file) {
        for (ArchiverEventListener<T> listener : this.listeners) {
            listener.itemStarted(this.klass.cast(this), file);
        }
    }

    protected boolean shouldSkip(File file) {
        return this.delegate != null && this.delegate.shouldSkip(this.klass.cast(this), file);
    }
}

