/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.names;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.locale.IsoLanguage;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.names.NameFinder;

public class BulkNameFinder
implements Serializable {
    private static final long serialVersionUID = -7709121230794406053L;
    private final LinkedHashSet<IsoLanguage> requestedLanguages = new LinkedHashSet();
    private final NameFinder finder = new NameFinder();
    private boolean forceLocalized;

    public static BulkNameFinder createStandardSet() {
        BulkNameFinder returnValue = new BulkNameFinder();
        returnValue.finder.withTags(NameFinder.STANDARD_TAGS);
        return returnValue;
    }

    public BulkNameFinder allLanguages() {
        this.requestedLanguages.addAll(IsoLanguage.allLanguageCodes().stream().map(languageCode -> IsoLanguage.forLanguageCode(languageCode).get()).collect(Collectors.toSet()));
        return this;
    }

    public BulkFindResults findIn(Taggable taggable) {
        if (this.forceLocalized) {
            this.finder.forceLocalized();
        } else {
            this.finder.localizedOnly();
        }
        DefaultBulkFindResults results = new DefaultBulkFindResults();
        for (IsoLanguage language : this.requestedLanguages) {
            results.put(language, this.finder.inLanguage(language).all(taggable));
        }
        results.put(this.finder.inLanguage(null).all(taggable));
        results.completed();
        return results;
    }

    public BulkFindResults findInWithMyLanguages(Taggable taggable, Taggable.TagSearchOption ... searchOptions) {
        EnumSet<Taggable.TagSearchOption> searchOptionSet = searchOptions.length > 0 ? EnumSet.copyOf(Arrays.asList(searchOptions)) : EnumSet.noneOf(Taggable.TagSearchOption.class);
        Taggable.TagSearchOption localizationOption = searchOptionSet.contains((Object)Taggable.TagSearchOption.FORCE_ALL_LOCALIZED_ONLY) ? Taggable.TagSearchOption.FORCE_ALL_LOCALIZED_ONLY : Taggable.TagSearchOption.LOCALIZED_ONLY;
        DefaultBulkFindResults results = new DefaultBulkFindResults();
        for (Class clazz : this.finder.getTagNames()) {
            if (!Validators.hasLocalizedTagKey(clazz) && localizationOption != Taggable.TagSearchOption.FORCE_ALL_LOCALIZED_ONLY) continue;
            taggable.languagesFor(clazz, searchOptions).ifPresent(languages -> {
                for (IsoLanguage language : languages) {
                    taggable.getTag(currentTag, Optional.of(language), localizationOption).ifPresent(value -> results.put(language, currentTag, (String)value));
                }
            });
        }
        results.put(this.finder.inLanguage(null).all(taggable));
        results.completed();
        return results;
    }

    public BulkNameFinder forceLocalized() {
        this.forceLocalized = true;
        return this;
    }

    public BulkNameFinder withLanguage(IsoLanguage ... languages) {
        this.requestedLanguages.addAll(Arrays.asList(languages));
        return this;
    }

    public BulkNameFinder withTags(Class<?> ... tags) {
        this.finder.withTags(tags);
        return this;
    }

    private static final class DefaultBulkFindResults
    implements BulkFindResults {
        private final Map<IsoLanguage, Map<Class<?>, String>> localizedResults = new HashMap();
        private final Map<Class<?>, String> nonLocalizedResults = new LinkedHashMap();
        private Map<String, String> flattenedMap = new HashMap<String, String>();

        private DefaultBulkFindResults() {
        }

        @Override
        public Optional<Map<Class<?>, String>> allValuesFor(Optional<IsoLanguage> language) {
            return Optional.ofNullable(language.isPresent() ? this.localizedResults.get(language.get()) : this.nonLocalizedResults);
        }

        @Override
        public Map<String, String> flatten() {
            return this.flattenedMap;
        }

        @Override
        public Iterable<IsoLanguage> languagesFound() {
            return this.localizedResults.keySet();
        }

        @Override
        public Optional<String> valueFor(Optional<IsoLanguage> language, Class<?> tagClass) {
            Map<Class<?>, String> results = language.isPresent() ? this.localizedResults.get(language.get()) : this.nonLocalizedResults;
            return Optional.ofNullable(results == null ? null : results.get(tagClass));
        }

        private void completed() {
            HashMap temporaryMap = new HashMap();
            for (Map.Entry<IsoLanguage, Map<Class<?>, String>> entry : this.localizedResults.entrySet()) {
                Optional<IsoLanguage> currentLanguage = Optional.of(entry.getKey());
                for (Map.Entry<Class<?>, String> itemEntry : entry.getValue().entrySet()) {
                    Validators.localizeKeyName(itemEntry.getKey(), currentLanguage, new Taggable.TagSearchOption[0]).ifPresent(localizedKeyName -> temporaryMap.put(localizedKeyName, (String)itemEntry.getValue()));
                }
            }
            for (Map.Entry<Serializable, Object> entry : this.nonLocalizedResults.entrySet()) {
                Validators.localizeKeyName((Class)entry.getKey(), Optional.empty(), new Taggable.TagSearchOption[0]).ifPresent(nonLocalizedKeyName -> temporaryMap.put(nonLocalizedKeyName, (String)entry.getValue()));
            }
            this.flattenedMap = new ImmutableMap.Builder().putAll(temporaryMap).build();
        }

        private void put(IsoLanguage language, Class<?> tag, String value) {
            Map<Class<?>, String> mapping = this.localizedResults.get(language);
            if (mapping == null) {
                mapping = new HashMap();
                this.localizedResults.put(language, mapping);
            }
            mapping.put(tag, value);
        }

        private void put(IsoLanguage language, Map<Class<?>, String> results) {
            this.localizedResults.put(language, results);
        }

        private void put(Map<Class<?>, String> results) {
            this.nonLocalizedResults.putAll(results);
        }
    }

    public static interface BulkFindResults {
        public Optional<Map<Class<?>, String>> allValuesFor(Optional<IsoLanguage> var1);

        public Map<String, String> flatten();

        public Iterable<IsoLanguage> languagesFound();

        public Optional<String> valueFor(Optional<IsoLanguage> var1, Class<?> var2);
    }
}

