/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.extraction;

import java.util.Optional;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.extraction.TagExtractor;
import org.openstreetmap.atlas.tags.annotations.validation.LongValidator;

public class LongExtractor
implements TagExtractor<Long> {
    @Override
    public Optional<Long> validateAndExtract(String value, Tag tag) {
        LongValidator validator = new LongValidator();
        Tag.Range range = tag.range();
        if (range != null) {
            validator.setRange(range.min(), range.max());
            for (long exclusion : range.exclude()) {
                validator.excludeValue(exclusion);
            }
        }
        if (validator.isValid(value)) {
            return Optional.of(Long.parseLong(value));
        }
        return Optional.empty();
    }
}

