/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.annotations.extraction;

import java.util.Optional;
import org.openstreetmap.atlas.geography.Altitude;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.extraction.LengthExtractor;
import org.openstreetmap.atlas.tags.annotations.extraction.TagExtractor;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class AltitudeExtractor
implements TagExtractor {
    public static Optional<Altitude> validateAndExtract(String value) {
        if (value.startsWith("-")) {
            Optional<Distance> distance = LengthExtractor.validateAndExtract(value.substring(1));
            return distance.map(distance1 -> Altitude.meters(distance1.asMeters() * -1.0));
        }
        Optional<Distance> distance = LengthExtractor.validateAndExtract(value);
        return distance.map(distance1 -> Altitude.meters(distance1.asMeters()));
    }

    public Optional<Altitude> validateAndExtract(String value, Tag tag) {
        return AltitudeExtractor.validateAndExtract(value);
    }
}

