/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.extraction.LengthExtractor;
import org.openstreetmap.atlas.utilities.scalars.Distance;

@Tag(value=Tag.Validation.DOUBLE, range=@Tag.Range(min=0L, max=0x7FFFFFFFL), taginfo="http://taginfo.openstreetmap.org/keys/width#values", osm="http://wiki.openstreetmap.org/wiki/Key:width")
public interface WidthTag {
    @TagKey
    public static final String KEY = "width";

    public static Optional<Distance> get(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            return LengthExtractor.validateAndExtract(tagValue.get());
        }
        return Optional.empty();
    }
}

