/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TurnLanesBackwardTag;
import org.openstreetmap.atlas.tags.TurnLanesForwardTag;
import org.openstreetmap.atlas.tags.TurnTag;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.OptionalIterable;

@Tag(value=Tag.Validation.NON_EMPTY_STRING, taginfo="http://taginfo.openstreetmap.org/keys/turn%3Alanes#values", osm="https://wiki.openstreetmap.org/wiki/Key:turn")
public interface TurnLanesTag
extends TurnTag {
    @TagKey
    public static final String KEY = "turn:lanes";

    public static Optional<List<Set<TurnTag.TurnType>>> getTurnLanes(Taggable taggable) {
        return taggable.getTag(KEY).map(tagValue -> Arrays.stream(tagValue.split("\\|")).map(lane -> Arrays.stream(lane.split(";")).map(TurnTag.TurnType::safeValueOf).filter(Objects::nonNull).collect(Collectors.toSet())).collect(Collectors.toList()));
    }

    public static boolean hasTurnLane(Taggable taggable, TurnTag.TurnType turnType) {
        OptionalIterable turnLanes = new OptionalIterable(Iterables.iterable(TurnLanesTag.getTurnLanes(taggable), TurnLanesForwardTag.getForwardTurnLanes(taggable), TurnLanesBackwardTag.getBackwardTurnLanes(taggable)));
        return Iterables.asList(turnLanes).stream().anyMatch(lanes -> lanes.stream().anyMatch(turnLane -> turnLane.contains((Object)turnType)));
    }

    public static boolean hasTurnLane(Taggable taggable) {
        return taggable.getTag(KEY).isPresent() || taggable.getTag("turn:lanes:forward").isPresent() || taggable.getTag("turn:lanes:backward").isPresent();
    }
}

