/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TurnLanesTag;
import org.openstreetmap.atlas.tags.TurnTag;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;

@Tag(value=Tag.Validation.NON_EMPTY_STRING, taginfo="http://taginfo.openstreetmap.org/keys/turn%3Alanes%3Abackward#values", osm="https://wiki.openstreetmap.org/wiki/Key:turn")
public interface TurnLanesBackwardTag
extends TurnLanesTag {
    @TagKey
    public static final String KEY = "turn:lanes:backward";

    public static Optional<List<Set<TurnTag.TurnType>>> getBackwardTurnLanes(Taggable taggable) {
        return taggable.getTag(KEY).map(tagValue -> Arrays.stream(tagValue.split("\\|")).map(lane -> Arrays.stream(lane.split(";")).map(TurnTag.TurnType::safeValueOf).filter(Objects::nonNull).collect(Collectors.toSet())).collect(Collectors.toList()));
    }

    public static boolean hasBackwardTurnLane(Taggable taggable, TurnTag.TurnType turnType) {
        return TurnLanesBackwardTag.getBackwardTurnLanes(taggable).map(lanes -> lanes.stream().anyMatch(turnLane -> turnLane.contains((Object)turnType))).orElse(false);
    }

    public static boolean hasBackwardTurnLane(Taggable taggable) {
        return taggable.getTag(KEY).isPresent();
    }
}

