/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.geography.Altitude;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.TagValue;
import org.openstreetmap.atlas.tags.annotations.extraction.AltitudeExtractor;

@Tag(value=Tag.Validation.DOUBLE, taginfo="http://taginfo.openstreetmap.org/keys/maxheight#values", osm="http://wiki.openstreetmap.org/wiki/Key:maxheight")
public interface MaxHeightTag {
    @TagKey
    public static final String KEY = "maxheight";
    @TagValue
    public static final String DEFAULT = "default";
    @TagValue
    public static final String NONE = "none";
    @TagValue(value=TagValue.ValueType.REGEX)
    public static final String METERS = "(\\d+(\\.\\d+)?|\\.\\d+)(\\sm)?";
    @TagValue(value=TagValue.ValueType.REGEX)
    public static final String FEET = "\\d'\\d\"";

    public static Optional<Altitude> get(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            return AltitudeExtractor.validateAndExtract(tagValue.get());
        }
        return Optional.empty();
    }
}

