/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import com.google.common.base.Joiner;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.locale.IsoLanguage;
import org.openstreetmap.atlas.utilities.collections.StringList;

public class LocalizedTagNameWithOptionalDate {
    private final String name;
    private Optional<IsoLanguage> language = Optional.empty();
    private Optional<String> untouchedDateRange = Optional.empty();

    public LocalizedTagNameWithOptionalDate(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        StringList list = StringList.split(key, ":");
        int nameBlocks = list.size();
        if (nameBlocks > 1) {
            if (list.get(nameBlocks - 1).contains("-")) {
                this.untouchedDateRange = Optional.of(list.get(--nameBlocks));
            }
            if (nameBlocks > 1) {
                this.language = IsoLanguage.forLanguageCode(list.get(nameBlocks - 1));
                if (this.language.isPresent()) {
                    --nameBlocks;
                }
            }
        }
        this.name = Joiner.on(":").join(list.stream().limit(nameBlocks).collect(Collectors.toList()));
    }

    public Optional<String> getDateRange() {
        return this.untouchedDateRange;
    }

    public Optional<IsoLanguage> getLanguage() {
        return this.language;
    }

    public String getName() {
        return this.name;
    }
}

