/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;

@Tag(value=Tag.Validation.NON_EMPTY_STRING, taginfo="http://taginfo.openstreetmap.org/keys/level#values", osm="http://wiki.openstreetmap.org/wiki/Level")
public interface LevelTag {
    @TagKey
    public static final String KEY = "level";

    public static boolean areOnSameLevel(Taggable taggableOne, Taggable taggableTwo) {
        Optional<String> levelTagEdgeOne = LevelTag.getTaggedValue(taggableOne);
        Optional<String> levelTagEdgeTwo = LevelTag.getTaggedValue(taggableTwo);
        if (levelTagEdgeOne.isPresent() && levelTagEdgeTwo.isPresent()) {
            return levelTagEdgeOne.get().equals(levelTagEdgeTwo.get());
        }
        return !levelTagEdgeOne.isPresent() && !levelTagEdgeTwo.isPresent();
    }

    public static String getTaggedOrImpliedValue(Taggable taggable, String impliedValue) {
        Optional<String> taggedValue = LevelTag.getTaggedValue(taggable);
        return taggedValue.isPresent() ? taggedValue.get() : impliedValue;
    }

    public static Optional<String> getTaggedValue(Taggable taggable) {
        return taggable.getTag(KEY);
    }
}

