/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.utilities.collections.Iterables;

@Tag(value=Tag.Validation.ISO3_COUNTRY)
public interface ISOCountryTag {
    @TagKey
    public static final String KEY = "iso_country_code";
    public static final String COUNTRY_MISSING = "N/A";
    public static final String COUNTRY_DELIMITER = ",";

    public static Iterable<String> all(Taggable taggable) {
        Optional<String> countryCode = taggable.getTag(ISOCountryTag.class, Optional.empty(), new Taggable.TagSearchOption[0]);
        if (countryCode.isPresent()) {
            return Arrays.asList(countryCode.get().split(COUNTRY_DELIMITER));
        }
        return ImmutableList.of();
    }

    public static Predicate<Taggable> allIn(Collection<String> countries) {
        if (countries.isEmpty()) {
            return taggable -> false;
        }
        return taggable -> {
            for (String country : ISOCountryTag.all(taggable)) {
                if (countries.contains(country)) continue;
                return false;
            }
            return true;
        };
    }

    public static Optional<String> first(Taggable taggable) {
        return Iterables.first(ISOCountryTag.all(taggable));
    }

    public static Predicate<Taggable> isIn(Set<String> countries) {
        if (countries.isEmpty()) {
            return taggable -> false;
        }
        return taggable -> {
            for (String country : ISOCountryTag.all(taggable)) {
                if (!countries.contains(country)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<Taggable> isIn(String countryToMatch) {
        if (countryToMatch == null || countryToMatch.isEmpty()) {
            return taggable -> false;
        }
        return taggable -> {
            for (String country : ISOCountryTag.all(taggable)) {
                if (!countryToMatch.equals(country)) continue;
                return true;
            }
            return false;
        };
    }

    public static String join(Collection<String> countries) {
        return String.join((CharSequence)COUNTRY_DELIMITER, countries);
    }
}

