/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags;

import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.extraction.OrdinalExtractor;

@Tag(value=Tag.Validation.ORDINAL, range=@Tag.Range(min=1L, max=11L), taginfo="https://taginfo.openstreetmap.org/keys/admin_level#values", osm="http://wiki.openstreetmap.org/wiki/Tag:boundary%3Dadministrative#10_admin_level_values_for_specific_countries")
public interface AdministrativeLevelTag {
    @TagKey
    public static final String KEY = "admin_level";

    public static Optional<Integer> getAdministrativeLevel(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            OrdinalExtractor extractor = new OrdinalExtractor();
            return extractor.validateAndExtract(tagValue.get(), AdministrativeLevelTag.class.getDeclaredAnnotation(Tag.class));
        }
        return Optional.empty();
    }

    public static long maximumAdministrativeLevelValue() {
        Tag tag = AdministrativeLevelTag.class.getDeclaredAnnotation(Tag.class);
        Tag.Range range = tag.range();
        return range.max();
    }

    public static long minimumAdministrativeLevelValue() {
        Tag tag = AdministrativeLevelTag.class.getDeclaredAnnotation(Tag.class);
        Tag.Range range = tag.range();
        return range.min();
    }
}

