/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.NotifyingIOUtils;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;

public interface WritableResource
extends Resource {
    default public void copyFrom(Resource input) {
        input.copyTo(this);
    }

    default public void copyFrom(Resource input, NotifyingIOUtils.IOProgressListener listener) {
        input.copyTo(this, listener);
    }

    public OutputStream write();

    default public void writeAndClose(byte[] value) {
        try (BufferedOutputStream output = new BufferedOutputStream(this.write());){
            output.write(value);
        }
        catch (Exception e) {
            throw new CoreException("Could not write to {}", this, e);
        }
    }

    default public void writeAndClose(String value) {
        try (SafeBufferedWriter writer = this.writer();){
            ((Writer)writer).write(value);
        }
        catch (Exception e) {
            throw new CoreException("Could not write to {}", this, e);
        }
    }

    default public SafeBufferedWriter writer() {
        return new SafeBufferedWriter(new OutputStreamWriter(this.write(), StandardCharsets.UTF_8));
    }
}

