/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.compression.Compressor;
import org.openstreetmap.atlas.streaming.compression.Decompressor;
import org.openstreetmap.atlas.streaming.resource.AbstractWritableResource;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.TemporaryFile;
import org.openstreetmap.atlas.utilities.runtime.Retry;
import org.openstreetmap.atlas.utilities.scalars.Duration;

public class File
extends AbstractWritableResource
implements Comparable<File> {
    private static final Random RANDOM = new Random();
    private final java.io.File javaFile;
    private String name = null;

    public static TemporaryFile temporary() {
        return new Retry(1, Duration.ZERO).run(() -> {
            try {
                return new TemporaryFile(java.io.File.createTempFile(String.valueOf(RANDOM.nextInt(Integer.MAX_VALUE)), FileSuffix.TEMPORARY.toString()));
            }
            catch (IOException e) {
                throw new CoreException("Unable to get temporary file.", e);
            }
        });
    }

    public static TemporaryFile temporary(String prefix, String suffix) {
        try {
            return new TemporaryFile(java.io.File.createTempFile(prefix, suffix));
        }
        catch (IOException e) {
            throw new CoreException("Unable to create a temporary file with prefix {} and suffix {}", prefix, suffix, e);
        }
    }

    public static TemporaryFile temporaryFolder() {
        try (TemporaryFile temporary = File.temporary();){
            TemporaryFile parent = new TemporaryFile(new TemporaryFile(temporary.getParent()).child("" + RANDOM.nextInt(Integer.MAX_VALUE)).getFile());
            parent.mkdirs();
            TemporaryFile temporaryFile = parent;
            return temporaryFile;
        }
    }

    public File(java.io.File file) {
        this(file, true);
    }

    public File(java.io.File file, boolean createParentDirectories) {
        this.javaFile = file;
        if (file.getAbsolutePath().endsWith(FileSuffix.GZIP.toString())) {
            this.setCompressor(Compressor.GZIP);
            this.setDecompressor(Decompressor.GZIP);
        }
        if (this.javaFile.getParentFile() != null && createParentDirectories) {
            this.javaFile.getParentFile().mkdirs();
        }
    }

    public File(String path) {
        this(new java.io.File(path), true);
    }

    public File(String path, boolean createParentDirectories) {
        this(new java.io.File(path), createParentDirectories);
    }

    public File child(String name) {
        if (!this.javaFile.isDirectory()) {
            throw new CoreException("Cannot create the child of a file. It has to be a folder.");
        }
        this.javaFile.mkdirs();
        return new File(this.getAbsolutePath() + "/" + name);
    }

    @Override
    public int compareTo(File other) {
        return this.getFile().compareTo(other.getFile());
    }

    public void delete() {
        try {
            Files.delete(this.getFile().toPath());
        }
        catch (IOException e) {
            throw new CoreException("Cannot delete file", e);
        }
    }

    public void deleteRecursively() {
        Path folder = this.getFile().toPath();
        try {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new CoreException("Cannot delete folder recursively", e);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof File) {
            return this.getFile().equals(((File)other).getFile());
        }
        return false;
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public String getAbsolutePath() {
        return this.javaFile.getAbsolutePath();
    }

    public java.io.File getFile() {
        return this.javaFile;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.javaFile.getName();
    }

    public String getParent() {
        return this.javaFile.getParent();
    }

    public String getPath() {
        return this.javaFile.getPath();
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public boolean isDirectory() {
        return this.javaFile.isDirectory();
    }

    @Override
    public long length() {
        return this.javaFile.length();
    }

    public List<File> listFilesRecursively() {
        ArrayList<File> result = new ArrayList<File>();
        if (this.getFile().isDirectory()) {
            for (java.io.File file : this.getFile().listFiles()) {
                File newFile = new File(file.getAbsolutePath());
                if (file.isDirectory()) {
                    result.addAll(newFile.listFilesRecursively());
                    continue;
                }
                result.add(newFile);
            }
        } else if (this.getFile().exists()) {
            result.add(this);
        }
        return result;
    }

    public boolean mkdirs() {
        return this.javaFile.mkdirs();
    }

    public File parent() {
        return new File(this.javaFile.getParent());
    }

    @Override
    public String toString() {
        return this.javaFile.getAbsolutePath();
    }

    public File withCompressor(Compressor compressor) {
        this.setCompressor(compressor);
        return this;
    }

    public File withDecompressor(Decompressor decompressor) {
        this.setDecompressor(decompressor);
        return this;
    }

    public File withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    protected InputStream onRead() {
        try {
            return new BufferedInputStream(new FileInputStream(this.javaFile));
        }
        catch (FileNotFoundException e) {
            throw new CoreException("Cannot read file " + this.javaFile.getPath(), e);
        }
    }

    @Override
    protected OutputStream onWrite() {
        try {
            return new BufferedOutputStream(new FileOutputStream(this.javaFile));
        }
        catch (FileNotFoundException e) {
            throw new CoreException("Cannot write to file " + this.javaFile.getPath(), e);
        }
    }
}

