/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.readers.json.converters;

import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.streaming.readers.json.converters.PointCoordinateConverter;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public class PolyLineCoordinateConverter
implements Converter<Iterable<Location>, JsonArray> {
    private final PointCoordinateConverter coordinateConverter = new PointCoordinateConverter();

    @Override
    public JsonArray convert(Iterable<Location> object) {
        JsonArray result = new JsonArray();
        object.forEach(location -> result.add(this.coordinateConverter.convert((Location)location)));
        return result;
    }

    public Converter<JsonArray, List<Location>> revert() {
        return jsonArray -> {
            ArrayList result = new ArrayList();
            jsonArray.forEach(jsonElement -> {
                JsonArray array = (JsonArray)jsonElement;
                result.add(this.coordinateConverter.revert().convert(array));
            });
            return result;
        };
    }
}

