/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.streaming.readers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.readers.json.deserializers.LocatedDeserializer;
import org.openstreetmap.atlas.streaming.readers.json.serializers.PropertiesLocated;
import org.openstreetmap.atlas.streaming.resource.Resource;

public class GeoJsonReader
implements Iterator<PropertiesLocated> {
    private final InputStream input;
    private final JsonReader reader;
    private final Gson gson;

    public GeoJsonReader(Resource source) {
        this.input = source.read();
        this.reader = new JsonReader(new InputStreamReader(this.input));
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Located.class), new LocatedDeserializer());
        this.gson = builder.create();
        try {
            this.reader.beginObject();
            if (!"type".equals(this.reader.nextName()) || !"FeatureCollection".equals(this.reader.nextString())) {
                throw new CoreException("Malformed feature collection");
            }
            String features = this.reader.nextName();
            while (!"features".equals(features)) {
                this.gson.fromJson(this.reader, (Type)((Object)JsonObject.class));
                features = this.reader.nextName();
            }
            this.reader.beginArray();
        }
        catch (Exception e) {
            Streams.close(this.input);
            throw new CoreException("Error reading GeoJson stream", e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            boolean hasNext;
            boolean bl = hasNext = this.reader.hasNext() && !this.reader.peek().equals((Object)JsonToken.END_ARRAY);
            if (!hasNext) {
                Streams.close(this.input);
            }
            return hasNext;
        }
        catch (IOException e) {
            Streams.close(this.input);
            throw new CoreException("Error reading GeoJson stream", e);
        }
    }

    @Override
    public PropertiesLocated next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Located geometry = null;
            JsonObject properties = null;
            this.reader.beginObject();
            while (this.reader.hasNext()) {
                String name = this.reader.nextName();
                if ("properties".equals(name)) {
                    properties = (JsonObject)this.gson.fromJson(this.reader, (Type)((Object)JsonObject.class));
                    continue;
                }
                if ("geometry".equals(name)) {
                    geometry = (Located)this.gson.fromJson(this.reader, (Type)((Object)Located.class));
                    continue;
                }
                this.reader.skipValue();
            }
            this.reader.endObject();
            if (geometry == null || properties == null) {
                throw new CoreException("Geometry or properties were null.");
            }
            return new PropertiesLocated(geometry, properties);
        }
        catch (IOException e) {
            Streams.close(this.input);
            throw new CoreException("Error reading GeoJson stream", e);
        }
    }
}

