/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.converters;

import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.proto.ProtoLocation;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class ProtoLocationConverter
implements TwoWayConverter<ProtoLocation, Location> {
    @Override
    public ProtoLocation backwardConvert(Location location) {
        ProtoLocation.Builder protoLocationBuilder = ProtoLocation.newBuilder();
        protoLocationBuilder.setLatitude(Math.toIntExact(location.getLatitude().asDm7()));
        protoLocationBuilder.setLongitude(Math.toIntExact(location.getLongitude().asDm7()));
        return protoLocationBuilder.build();
    }

    @Override
    public Location convert(ProtoLocation protoLocation) {
        Longitude longitude = Longitude.dm7(protoLocation.getLongitude());
        Latitude latitude = Latitude.dm7(protoLocation.getLatitude());
        return new Location(latitude, longitude);
    }
}

