/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.builder;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.ReverseIdentifierFactory;
import org.openstreetmap.atlas.proto.ProtoArea;
import org.openstreetmap.atlas.proto.ProtoAtlas;
import org.openstreetmap.atlas.proto.ProtoAtlasMetaData;
import org.openstreetmap.atlas.proto.ProtoEdge;
import org.openstreetmap.atlas.proto.ProtoLine;
import org.openstreetmap.atlas.proto.ProtoNode;
import org.openstreetmap.atlas.proto.ProtoPoint;
import org.openstreetmap.atlas.proto.ProtoRelation;
import org.openstreetmap.atlas.proto.converters.ProtoLocationConverter;
import org.openstreetmap.atlas.proto.converters.ProtoTagListConverter;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoAtlasBuilder {
    private static final ProtoLocationConverter PROTOLOCATION_CONVERTER = new ProtoLocationConverter();
    private static final ProtoTagListConverter PROTOTAG_LIST_CONVERTER = new ProtoTagListConverter();
    private static final ReverseIdentifierFactory REVERSE_IDENTIFIER_FACTORY = new ReverseIdentifierFactory();
    private static final Logger logger = LoggerFactory.getLogger(ProtoAtlasBuilder.class);
    private static final String NULL_SENTINEL = "unknown";
    public static final String PROTOATLAS_DATA_VERSION = "ProtoAtlas";

    public PackedAtlas read(Resource resource) {
        boolean hasAllAtlasSizeFeatures;
        ProtoAtlas protoAtlas = null;
        try {
            protoAtlas = ProtoAtlas.parseFrom(resource.readBytesAndClose());
        }
        catch (InvalidProtocolBufferException exception) {
            throw new CoreException("Error deserializing the ProtoAtlasContainer from {}", resource.getName(), exception);
        }
        ProtoAtlasMetaData protoAtlasMetaData = protoAtlas.getMetaData();
        AtlasSize atlasSize = null;
        boolean bl = hasAllAtlasSizeFeatures = protoAtlasMetaData.hasEdgeNumber() && protoAtlasMetaData.hasNodeNumber() && protoAtlasMetaData.hasAreaNumber() && protoAtlasMetaData.hasLineNumber() && protoAtlasMetaData.hasPointNumber() && protoAtlasMetaData.hasRelationNumber();
        if (hasAllAtlasSizeFeatures) {
            atlasSize = new AtlasSize(protoAtlasMetaData.getEdgeNumber(), protoAtlasMetaData.getNodeNumber(), protoAtlasMetaData.getAreaNumber(), protoAtlasMetaData.getLineNumber(), protoAtlasMetaData.getPointNumber(), protoAtlasMetaData.getRelationNumber());
        } else {
            logger.warn("Could not deserialize AtlasSize, using defaults");
            atlasSize = AtlasSize.DEFAULT;
        }
        String codeVersion = protoAtlasMetaData.hasCodeVersion() ? protoAtlasMetaData.getCodeVersion() : NULL_SENTINEL;
        String dataVersion = protoAtlasMetaData.hasDataVersion() ? protoAtlasMetaData.getDataVersion() : NULL_SENTINEL;
        String country = protoAtlasMetaData.hasCountry() ? protoAtlasMetaData.getCountry() : NULL_SENTINEL;
        String shardName = protoAtlasMetaData.hasShardName() ? protoAtlasMetaData.getShardName() : NULL_SENTINEL;
        Map<String, String> tags = PROTOTAG_LIST_CONVERTER.convert(protoAtlasMetaData.getTagsList());
        AtlasMetaData atlasMetaData = new AtlasMetaData(atlasSize, protoAtlasMetaData.getOriginal(), codeVersion, dataVersion, country, shardName, tags);
        PackedAtlasBuilder builder = new PackedAtlasBuilder().withSizeEstimates(atlasSize).withMetaData(atlasMetaData).withName(resource.getName());
        this.parsePoints(builder, protoAtlas.getPointsList());
        this.parseLines(builder, protoAtlas.getLinesList());
        this.parseAreas(builder, protoAtlas.getAreasList());
        this.parseNodes(builder, protoAtlas.getNodesList());
        this.parseEdges(builder, protoAtlas.getEdgesList());
        this.parseRelations(builder, protoAtlas.getRelationsList());
        return (PackedAtlas)builder.get();
    }

    public void write(Atlas atlas, WritableResource resource) {
        ProtoAtlas.Builder protoAtlasBuilder = ProtoAtlas.newBuilder();
        this.writePointsToBuilder(atlas, protoAtlasBuilder);
        this.writeLinesToBuilder(atlas, protoAtlasBuilder);
        this.writeAreasToBuilder(atlas, protoAtlasBuilder);
        this.writeNodesToBuilder(atlas, protoAtlasBuilder);
        this.writeEdgesToBuilder(atlas, protoAtlasBuilder);
        this.writeRelationsToBuilder(atlas, protoAtlasBuilder);
        AtlasMetaData atlasMetaData = atlas.metaData();
        ProtoAtlasMetaData.Builder protoMetaDataBuilder = ProtoAtlasMetaData.newBuilder();
        if (atlasMetaData.getSize() != null) {
            protoMetaDataBuilder.setEdgeNumber(atlasMetaData.getSize().getEdgeNumber());
            protoMetaDataBuilder.setNodeNumber(atlasMetaData.getSize().getNodeNumber());
            protoMetaDataBuilder.setAreaNumber(atlasMetaData.getSize().getAreaNumber());
            protoMetaDataBuilder.setLineNumber(atlasMetaData.getSize().getLineNumber());
            protoMetaDataBuilder.setPointNumber(atlasMetaData.getSize().getPointNumber());
            protoMetaDataBuilder.setRelationNumber(atlasMetaData.getSize().getRelationNumber());
        }
        protoMetaDataBuilder.setOriginal(atlasMetaData.isOriginal());
        atlasMetaData.getCodeVersion().ifPresent(protoMetaDataBuilder::setCodeVersion);
        atlasMetaData.getDataVersion().ifPresent(protoMetaDataBuilder::setDataVersion);
        atlasMetaData.getCountry().ifPresent(protoMetaDataBuilder::setCountry);
        atlasMetaData.getShardName().ifPresent(protoMetaDataBuilder::setShardName);
        if (atlasMetaData.getTags() != null) {
            protoMetaDataBuilder.addAllTags(PROTOTAG_LIST_CONVERTER.backwardConvert(atlasMetaData.getTags()));
        }
        protoAtlasBuilder.setMetaData(protoMetaDataBuilder);
        ProtoAtlas protoAtlas = protoAtlasBuilder.build();
        resource.writeAndClose(protoAtlas.toByteArray());
    }

    private void parseAreas(PackedAtlasBuilder builder, List<ProtoArea> areas) {
        areas.forEach(protoArea -> {
            long identifier = protoArea.getId();
            List<Location> shapePoints = protoArea.getShapePointsList().stream().map(PROTOLOCATION_CONVERTER::convert).collect(Collectors.toList());
            Polygon geometry = new Polygon(shapePoints);
            Map<String, String> tags = PROTOTAG_LIST_CONVERTER.convert(protoArea.getTagsList());
            builder.addArea(identifier, geometry, tags);
        });
    }

    private void parseEdges(PackedAtlasBuilder builder, List<ProtoEdge> edges) {
        edges.forEach(protoEdge -> {
            long identifier = protoEdge.getId();
            List shapePoints = protoEdge.getShapePointsList().stream().map(PROTOLOCATION_CONVERTER::convert).collect(Collectors.toList());
            PolyLine geometry = new PolyLine(shapePoints);
            Map<String, String> tags = PROTOTAG_LIST_CONVERTER.convert(protoEdge.getTagsList());
            builder.addEdge(identifier, geometry, tags);
        });
    }

    private void parseLines(PackedAtlasBuilder builder, List<ProtoLine> lines) {
        lines.forEach(protoLine -> {
            long identifier = protoLine.getId();
            List shapePoints = protoLine.getShapePointsList().stream().map(PROTOLOCATION_CONVERTER::convert).collect(Collectors.toList());
            PolyLine geometry = new PolyLine(shapePoints);
            Map<String, String> tags = PROTOTAG_LIST_CONVERTER.convert(protoLine.getTagsList());
            builder.addLine(identifier, geometry, tags);
        });
    }

    private void parseNodes(PackedAtlasBuilder builder, List<ProtoNode> nodes) {
        nodes.forEach(protoNode -> {
            long identifier = protoNode.getId();
            Longitude longitude = Longitude.dm7(protoNode.getLocation().getLongitude());
            Latitude latitude = Latitude.dm7(protoNode.getLocation().getLatitude());
            Location geometry = new Location(latitude, longitude);
            Map<String, String> tags = PROTOTAG_LIST_CONVERTER.convert(protoNode.getTagsList());
            builder.addNode(identifier, geometry, tags);
        });
    }

    private void parsePoints(PackedAtlasBuilder builder, List<ProtoPoint> points) {
        points.forEach(protoPoint -> {
            long identifier = protoPoint.getId();
            Longitude longitude = Longitude.dm7(protoPoint.getLocation().getLongitude());
            Latitude latitude = Latitude.dm7(protoPoint.getLocation().getLatitude());
            Location geometry = new Location(latitude, longitude);
            Map<String, String> tags = PROTOTAG_LIST_CONVERTER.convert(protoPoint.getTagsList());
            builder.addPoint(identifier, geometry, tags);
        });
    }

    private RelationBean parseRelationBean(ProtoRelation protoRelation) {
        RelationBean bean = new RelationBean();
        protoRelation.getBeansList().forEach(protoRelationBean -> {
            long memberId = protoRelationBean.getMemberId();
            String memberRole = protoRelationBean.getMemberRole();
            ItemType memberType = ItemType.forValue(protoRelationBean.getMemberType().getNumber());
            bean.addItem(memberId, memberRole, memberType);
        });
        return bean;
    }

    private void parseRelations(PackedAtlasBuilder builder, List<ProtoRelation> relations) {
        relations.forEach(protoRelation -> {
            long identifier = protoRelation.getId();
            RelationBean bean = this.parseRelationBean((ProtoRelation)protoRelation);
            Map<String, String> tags = PROTOTAG_LIST_CONVERTER.convert(protoRelation.getTagsList());
            builder.addRelation(identifier, REVERSE_IDENTIFIER_FACTORY.getOsmIdentifier(identifier), bean, tags);
        });
    }

    private void writeAreasToBuilder(Atlas atlas, ProtoAtlas.Builder protoAtlasBuilder) {
        long numberOfAreas = 0L;
        for (Area area : atlas.areas()) {
            ProtoArea.Builder protoAreaBuilder = ProtoArea.newBuilder();
            protoAreaBuilder.setId(area.getIdentifier());
            List protoLocations = area.asPolygon().stream().map(PROTOLOCATION_CONVERTER::backwardConvert).collect(Collectors.toList());
            protoAreaBuilder.addAllShapePoints(protoLocations);
            Map<String, String> tags = area.getTags();
            protoAreaBuilder.addAllTags(PROTOTAG_LIST_CONVERTER.backwardConvert(tags));
            ++numberOfAreas;
            protoAtlasBuilder.addAreas(protoAreaBuilder.build());
        }
        protoAtlasBuilder.setNumberOfAreas(numberOfAreas);
    }

    private void writeEdgesToBuilder(Atlas atlas, ProtoAtlas.Builder protoAtlasBuilder) {
        long numberOfEdges = 0L;
        for (Edge edge : atlas.edges()) {
            ProtoEdge.Builder protoEdgeBuilder = ProtoEdge.newBuilder();
            protoEdgeBuilder.setId(edge.getIdentifier());
            List protoLocations = edge.asPolyLine().stream().map(PROTOLOCATION_CONVERTER::backwardConvert).collect(Collectors.toList());
            protoEdgeBuilder.addAllShapePoints(protoLocations);
            Map<String, String> tags = edge.getTags();
            protoEdgeBuilder.addAllTags(PROTOTAG_LIST_CONVERTER.backwardConvert(tags));
            ++numberOfEdges;
            protoAtlasBuilder.addEdges(protoEdgeBuilder.build());
        }
        protoAtlasBuilder.setNumberOfEdges(numberOfEdges);
    }

    private void writeLinesToBuilder(Atlas atlas, ProtoAtlas.Builder protoAtlasBuilder) {
        long numberOfLines = 0L;
        for (Line line : atlas.lines()) {
            ProtoLine.Builder protoLineBuilder = ProtoLine.newBuilder();
            protoLineBuilder.setId(line.getIdentifier());
            List protoLocations = line.asPolyLine().stream().map(PROTOLOCATION_CONVERTER::backwardConvert).collect(Collectors.toList());
            protoLineBuilder.addAllShapePoints(protoLocations);
            Map<String, String> tags = line.getTags();
            protoLineBuilder.addAllTags(PROTOTAG_LIST_CONVERTER.backwardConvert(tags));
            ++numberOfLines;
            protoAtlasBuilder.addLines(protoLineBuilder.build());
        }
        protoAtlasBuilder.setNumberOfLines(numberOfLines);
    }

    private void writeNodesToBuilder(Atlas atlas, ProtoAtlas.Builder protoAtlasBuilder) {
        long numberOfNodes = 0L;
        for (Node node : atlas.nodes()) {
            ProtoNode.Builder protoNodeBuilder = ProtoNode.newBuilder();
            protoNodeBuilder.setId(node.getIdentifier());
            protoNodeBuilder.setLocation(PROTOLOCATION_CONVERTER.backwardConvert(node.getLocation()));
            Map<String, String> tags = node.getTags();
            protoNodeBuilder.addAllTags(PROTOTAG_LIST_CONVERTER.backwardConvert(tags));
            ++numberOfNodes;
            protoAtlasBuilder.addNodes(protoNodeBuilder.build());
        }
        protoAtlasBuilder.setNumberOfNodes(numberOfNodes);
    }

    private void writePointsToBuilder(Atlas atlas, ProtoAtlas.Builder protoAtlasBuilder) {
        long numberOfPoints = 0L;
        for (Point point : atlas.points()) {
            ProtoPoint.Builder protoPointBuilder = ProtoPoint.newBuilder();
            protoPointBuilder.setId(point.getIdentifier());
            protoPointBuilder.setLocation(PROTOLOCATION_CONVERTER.backwardConvert(point.getLocation()));
            Map<String, String> tags = point.getTags();
            protoPointBuilder.addAllTags(PROTOTAG_LIST_CONVERTER.backwardConvert(tags));
            ++numberOfPoints;
            protoAtlasBuilder.addPoints(protoPointBuilder.build());
        }
        protoAtlasBuilder.setNumberOfPoints(numberOfPoints);
    }

    private void writeRelationsToBuilder(Atlas atlas, ProtoAtlas.Builder protoAtlasBuilder) {
        long numberOfRelations = 0L;
        for (Relation relation : atlas.relations()) {
            ProtoRelation.Builder protoRelationBuilder = ProtoRelation.newBuilder();
            protoRelationBuilder.setId(relation.getIdentifier());
            for (RelationMember member : relation.members()) {
                ProtoRelation.RelationBean.Builder beanBuilder = ProtoRelation.RelationBean.newBuilder();
                beanBuilder.setMemberId(member.getEntity().getIdentifier());
                beanBuilder.setMemberRole(member.getRole());
                ItemType type = ItemType.forEntity(member.getEntity());
                beanBuilder.setMemberType(ProtoRelation.ProtoItemType.valueOf(type.getValue()));
                protoRelationBuilder.addBeans(beanBuilder.build());
            }
            Map<String, String> tags = relation.getTags();
            protoRelationBuilder.addAllTags(PROTOTAG_LIST_CONVERTER.backwardConvert(tags));
            ++numberOfRelations;
            protoAtlasBuilder.addRelations(protoRelationBuilder.build());
        }
        protoAtlasBuilder.setNumberOfRelations(numberOfRelations);
    }
}

