/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.adapters;

import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.reflect.Field;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.packed.PackedTagStore;
import org.openstreetmap.atlas.proto.ProtoIntegerArrayOfArrays;
import org.openstreetmap.atlas.proto.ProtoPackedTagStore;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.converters.ProtoIntegerArrayOfArraysConverter;
import org.openstreetmap.atlas.utilities.arrays.IntegerArrayOfArrays;

public class ProtoPackedTagStoreAdapter
implements ProtoAdapter {
    private static final ProtoIntegerArrayOfArraysConverter CONVERTER = new ProtoIntegerArrayOfArraysConverter();

    @Override
    public ProtoSerializable deserialize(byte[] byteArray) {
        ProtoPackedTagStore protoStore = null;
        try {
            protoStore = ProtoPackedTagStore.parseFrom(byteArray);
        }
        catch (InvalidProtocolBufferException exception) {
            throw new CoreException("Error encountered while parsing protobuf bytestream", exception);
        }
        PackedTagStore store = new PackedTagStore();
        ProtoIntegerArrayOfArrays protoKeyArray = protoStore.getKeys();
        ProtoIntegerArrayOfArrays protoValueArray = protoStore.getValues();
        IntegerArrayOfArrays keyArray = CONVERTER.convert(protoKeyArray);
        IntegerArrayOfArrays valueArray = CONVERTER.convert(protoValueArray);
        Long index = protoStore.getIndex();
        Field keyArrayField = null;
        Field valueArrayField = null;
        Field indexField = null;
        try {
            keyArrayField = store.getClass().getDeclaredField("keys");
            keyArrayField.setAccessible(true);
            keyArrayField.set(store, keyArray);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to set field \"{}\" in {}", "keys", store.getClass().getName(), exception);
        }
        try {
            valueArrayField = store.getClass().getDeclaredField("values");
            valueArrayField.setAccessible(true);
            valueArrayField.set(store, valueArray);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to set field \"{}\" in {}", "values", store.getClass().getName(), exception);
        }
        try {
            indexField = store.getClass().getDeclaredField("index");
            indexField.setAccessible(true);
            indexField.set(store, index);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to set field \"{}\" in {}", "index", store.getClass().getName(), exception);
        }
        return store;
    }

    @Override
    public byte[] serialize(ProtoSerializable serializable) {
        if (!(serializable instanceof PackedTagStore)) {
            throw new CoreException("Invalid ProtoSerializable type was provided to {}: cannot serialize {}", this.getClass().getName(), serializable.getClass().getName());
        }
        PackedTagStore store = (PackedTagStore)serializable;
        ProtoPackedTagStore.Builder protoTagStoreBuilder = ProtoPackedTagStore.newBuilder();
        Field keyArrayField = null;
        IntegerArrayOfArrays keyArray = null;
        Field valueArrayField = null;
        IntegerArrayOfArrays valueArray = null;
        Field indexField = null;
        Long index = -1L;
        try {
            keyArrayField = store.getClass().getDeclaredField("keys");
            keyArrayField.setAccessible(true);
            keyArray = (IntegerArrayOfArrays)keyArrayField.get(store);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to read field \"{}\" from {}", "keys", store.getClass().getName(), exception);
        }
        try {
            valueArrayField = store.getClass().getDeclaredField("values");
            valueArrayField.setAccessible(true);
            valueArray = (IntegerArrayOfArrays)valueArrayField.get(store);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to read field \"{}\" from {}", "values", store.getClass().getName(), exception);
        }
        try {
            indexField = store.getClass().getDeclaredField("index");
            indexField.setAccessible(true);
            index = (Long)indexField.get(store);
        }
        catch (Exception exception) {
            throw new CoreException("Unable to read field \"{}\" from {}", "index", store.getClass().getName(), exception);
        }
        try {
            protoTagStoreBuilder.setKeys(CONVERTER.backwardConvert(keyArray));
        }
        catch (Exception exception) {
            throw new CoreException("Failed to serialize {}", keyArray.getClass().getName(), exception);
        }
        try {
            protoTagStoreBuilder.setValues(CONVERTER.backwardConvert(valueArray));
        }
        catch (Exception exception) {
            throw new CoreException("Failed to serialize {}", valueArray.getClass().getName(), exception);
        }
        protoTagStoreBuilder.setIndex(index);
        return protoTagStoreBuilder.build().toByteArray();
    }
}

