/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.proto.adapters;

import com.google.protobuf.InvalidProtocolBufferException;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.proto.ProtoLongArray;
import org.openstreetmap.atlas.proto.ProtoLongToLongMultiMap;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.utilities.maps.LongToLongMultiMap;

public class ProtoLongToLongMultiMapAdapter
implements ProtoAdapter {
    private static final int DEFAULT_MAX_SIZE = 1024;

    @Override
    public ProtoSerializable deserialize(byte[] byteArray) {
        ProtoLongToLongMultiMap protoLongToLongMultiMap = null;
        try {
            protoLongToLongMultiMap = ProtoLongToLongMultiMap.parseFrom(byteArray);
        }
        catch (InvalidProtocolBufferException exception) {
            throw new CoreException("Error encountered while parsing protobuf bytestream", exception);
        }
        String deserializedName = null;
        if (protoLongToLongMultiMap.hasName()) {
            deserializedName = protoLongToLongMultiMap.getName();
        }
        int size = protoLongToLongMultiMap.getKeys().getElementsCount() <= 1024 ? 1024 : protoLongToLongMultiMap.getKeys().getElementsCount();
        LongToLongMultiMap longToLongMultiMap = new LongToLongMultiMap(deserializedName, size, size, size, size, size, size);
        for (int index = 0; index < protoLongToLongMultiMap.getKeys().getElementsCount(); ++index) {
            ProtoLongArray protoLongArray = protoLongToLongMultiMap.getValuesList().get(index);
            long[] values = protoLongArray.getElementsList().stream().mapToLong(Long::longValue).toArray();
            longToLongMultiMap.put(protoLongToLongMultiMap.getKeys().getElements(index), values);
        }
        return longToLongMultiMap;
    }

    @Override
    public byte[] serialize(ProtoSerializable serializable) {
        if (!(serializable instanceof LongToLongMultiMap)) {
            throw new CoreException("Invalid ProtoSerializable type was provided to {}: cannot serialize {}", this.getClass().getName(), serializable.getClass().getName());
        }
        LongToLongMultiMap longMultiMap = (LongToLongMultiMap)serializable;
        if (longMultiMap.size() > Integer.MAX_VALUE) {
            throw new CoreException("Cannot serialize {}, size too large ({})", longMultiMap.getClass().getName(), longMultiMap.size());
        }
        if (longMultiMap.size() > Integer.MAX_VALUE) {
            throw new CoreException("Cannot serialize provided {}, size {} too large", serializable.getClass().getName(), longMultiMap.size());
        }
        ProtoLongToLongMultiMap.Builder protoMapBuilder = ProtoLongToLongMultiMap.newBuilder();
        ProtoLongArray.Builder keysBuilder = ProtoLongArray.newBuilder();
        Iterable iterable = () -> longMultiMap.iterator();
        for (Long key : iterable) {
            ProtoLongArray.Builder valuesBuilder = ProtoLongArray.newBuilder();
            long[] value = (long[])longMultiMap.get(key);
            if (value == null) {
                throw new CoreException("{} cannot serialize arrays with null elements", this.getClass().getName());
            }
            keysBuilder.addElements(key);
            for (int index = 0; index < value.length; ++index) {
                valuesBuilder.addElements(value[index]);
            }
            protoMapBuilder.addValues(valuesBuilder);
        }
        protoMapBuilder.setKeys(keysBuilder);
        if (longMultiMap.getName() != null) {
            protoMapBuilder.setName(longMultiMap.getName());
        }
        return protoMapBuilder.build().toByteArray();
    }
}

