/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.Serializable;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.geojson.GeoJson;
import org.openstreetmap.atlas.geography.geojson.GeoJsonType;
import org.openstreetmap.atlas.geography.sharding.DynamicTileSharding;
import org.openstreetmap.atlas.geography.sharding.GeoHashSharding;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTileSharding;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.collections.StringList;

public interface Sharding
extends Serializable,
GeoJson {
    public static final int SHARDING_STRING_SPLIT = 2;
    public static final int SLIPPY_ZOOM_MAXIMUM = 18;

    public static Sharding forString(String sharding) {
        StringList split = StringList.split(sharding, "@");
        if (split.size() != 2) {
            throw new CoreException("Invalid sharding string: {} (correct e.g. dynamic@/path/to/tree, slippy@9, etc.)", sharding);
        }
        if ("slippy".equals(split.get(0))) {
            int zoom = Integer.valueOf(split.get(1));
            if (zoom > 18) {
                throw new CoreException("Slippy Sharding zoom too high : {}, max is {}", zoom, 18);
            }
            return new SlippyTileSharding(zoom);
        }
        if ("geohash".equals(split.get(0))) {
            int precision = Integer.valueOf(split.get(1));
            return new GeoHashSharding(precision);
        }
        if ("dynamic".equals(split.get(0))) {
            String definition = split.get(1);
            return new DynamicTileSharding(new File(definition));
        }
        throw new CoreException("Sharding type {} is not recognized.", split.get(0));
    }

    @Override
    default public JsonObject asGeoJson() {
        JsonObject featureCollectionObject = new JsonObject();
        featureCollectionObject.addProperty("type", "FeatureCollection");
        JsonArray features = new JsonArray();
        for (Shard shard : this.shards(Rectangle.MAXIMUM)) {
            JsonObject featureObject = new JsonObject();
            featureObject.addProperty("type", "Feature");
            featureObject.add("geometry", new PolyLine(shard.bounds().closedLoop()).asGeoJsonGeometry());
            JsonObject propertiesObject = new JsonObject();
            propertiesObject.addProperty("shard", shard.getName());
            featureObject.add("properties", propertiesObject);
            features.add(featureObject);
        }
        featureCollectionObject.add("features", features);
        return featureCollectionObject;
    }

    @Override
    default public GeoJsonType getGeoJsonType() {
        return GeoJsonType.FEATURE_COLLECTION;
    }

    public Iterable<Shard> neighbors(Shard var1);

    public Shard shardForName(String var1);

    default public Iterable<Shard> shards() {
        return this.shards(Rectangle.MAXIMUM);
    }

    public Iterable<Shard> shards(GeometricSurface var1);

    public Iterable<Shard> shardsCovering(Location var1);

    public Iterable<Shard> shardsIntersecting(PolyLine var1);
}

