/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding;

import java.util.Set;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class LocationToShardCommand
extends Command {
    private static final Command.Switch<Sharding> SHARDING = new Command.Switch("sharding", "The sharding tree", Sharding::forString, Command.Optionality.REQUIRED);
    private static final Command.Switch<Location> LOCATION = new Command.Switch("location", "The location to check as \"latitude,longitude\"", Location::forString, Command.Optionality.OPTIONAL);
    private static final Command.Switch<Location> WKT_POINT = new Command.Switch("wktPoint", "The location to check as a WKT point", Location::forWkt, Command.Optionality.OPTIONAL);

    public static void main(String[] args) {
        new LocationToShardCommand().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        Sharding sharding = (Sharding)command.get(SHARDING);
        Location location = (Location)command.get(LOCATION);
        if (location == null) {
            location = (Location)command.get(WKT_POINT);
        }
        if (location == null) {
            System.err.println("No location found! Make sure to use either the -" + LOCATION.getName() + " or -" + WKT_POINT.getName() + " switch.");
            return 0;
        }
        Set<Shard> shards = Iterables.asSet(sharding.shardsCovering(location));
        if (shards.size() <= 0) {
            System.err.println("No shard found!");
            return 1;
        }
        System.out.println("Shard(s) covering " + location.toCompactString() + ":");
        shards.forEach(shard -> System.out.println(shard.getName() + "; " + shard.bounds().toWkt()));
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(SHARDING, LOCATION, WKT_POINT);
    }
}

